<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ChecksService;

class GoogleChecksReportV1alphaAppBundle extends \Google\Model
{
  /**
   * @var string
   */
  public $bundleId;
  /**
   * @var string
   */
  public $codeReferenceId;
  /**
   * @var string
   */
  public $releaseType;
  /**
   * @var string
   */
  public $version;
  /**
   * @var string
   */
  public $versionId;

  /**
   * @param string
   */
  public function setBundleId($bundleId)
  {
    $this->bundleId = $bundleId;
  }
  /**
   * @return string
   */
  public function getBundleId()
  {
    return $this->bundleId;
  }
  /**
   * @param string
   */
  public function setCodeReferenceId($codeReferenceId)
  {
    $this->codeReferenceId = $codeReferenceId;
  }
  /**
   * @return string
   */
  public function getCodeReferenceId()
  {
    return $this->codeReferenceId;
  }
  /**
   * @param string
   */
  public function setReleaseType($releaseType)
  {
    $this->releaseType = $releaseType;
  }
  /**
   * @return string
   */
  public function getReleaseType()
  {
    return $this->releaseType;
  }
  /**
   * @param string
   */
  public function setVersion($version)
  {
    $this->version = $version;
  }
  /**
   * @return string
   */
  public function getVersion()
  {
    return $this->version;
  }
  /**
   * @param string
   */
  public function setVersionId($versionId)
  {
    $this->versionId = $versionId;
  }
  /**
   * @return string
   */
  public function getVersionId()
  {
    return $this->versionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleChecksReportV1alphaAppBundle::class, 'Google_Service_ChecksService_GoogleChecksReportV1alphaAppBundle');
