<?php
$page_name = "Email Verification";
include 'include/header-main-auth.php';
function maskEmail($email) {
    // Split the email address into username and domain parts
    list($username, $domain) = explode('@', $email);

    // Get the length of the username
    $usernameLength = strlen($username);

    // Mask the username with asterisks, keeping the first two characters
    $maskedUsername = substr($username, 0, 2) . str_repeat('*', $usernameLength - 2);

    // Reconstruct the masked email address
    $maskedEmail = $maskedUsername . '@' . $domain;

    return $maskedEmail;
}
?>
    <wc-toast id="tt" position="top-center"> </wc-toast>    
    
<div class="flex justify-center items-center min-h-screen bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] bg-cover bg-center">
    <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
        <div class="flex items-center mb-10">
            <div class="ltr:mr-4 rtl:ml-4">
                <img src="https://cdn-icons-png.flaticon.com/512/2919/2919906.png" class="w-16 h-16 object-cover rounded-full" alt="images" />
            </div>
            <div class="flex-1">
                <h4 class="text-2xl">Email Verification</h4>
                <p>Verify your email by inputing the code sent to <?= maskEmail($_SESSION['registered_email']) ?> here:</p>
            </div>
        </div>
        <div class="space-y-5">
            <div>
                <label for="email_code">Enter code</label>
                <input id="email_code" type="number" class="form-input" placeholder="Enter 6 Digit Otp" />
            </div>
            <button type="submit" id="email_unlock" class="btn btn-primary w-full">UNLOCK</button>
        </div>
    </div>
</div>
<?php 
include("include/custom_js_new.php");
?>   
<?php
include 'include/footer-main-auth.php';
?>
