<?php
$page_name = "Forget Password";
include 'include/header-main-auth.php';
?>
<wc-toast id="tt" position="top-center"></wc-toast>

<div class="flex justify-center items-center min-h-screen bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] bg-cover bg-center">
    <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
        <div class="mb-10">
            <h4 class="text-2xl">Reset Password</h4>
            <p>Fill in your new password details below:</p>
        </div>
        <form id="reset-pass-form" class="space-y-5">
            <input type="hidden" name="email" value="<?php echo $email ?>"/>
            <div class="relative">
                <label for="password">New Password:</label>
                <input id="password" type="password" name="password" class="form-input pwd" placeholder="Enter new password" />
                <div class="visibility-container text-base text-[#515365] dark:text-white-dark">
                    <i class="fa fa-eye"></i>
                </div>
            </div>
            <div class="relative">
                <label for="confirm_password">Retype New Password:</label>
                <input id="confirm_password" type="text" name="confirm_password" class="form-input pwd" placeholder="Retype new password" />
                <div class="visibility-container text-base text-[#515365] dark:text-white-dark">
                    <i class="fa fa-eye"></i>
                </div>
            </div>
            <button type="submit" id="submit" class="btn btn-primary w-full">Submit</button>
        </form>
    </div>
</div>
<script>
    // PASSWORD VISIBILITY TOGGLER
    $(".visibility-container").each(function(index) {
            $(this).on("click", function() {
                const icon = $(this).children()[0]

                if (icon.getAttribute("class") === "fa fa-eye") {
                    icon.setAttribute("class", "fa fa-eye-slash");

                    $(".pwd")[index].setAttribute("type", "text");
                } else {
                    icon.setAttribute("class", "fa fa-eye");
                    $(".pwd")[index].setAttribute("type", "password");
                }
            });
        })
</script>
<?php
include("include/custom_js.php");
?>
<?php
include 'include/footer-main-auth.php';
?>