<?php
$page_name = "Register";
include 'include/header-main-auth.php';
?>
<wc-toast id="tt" position="top-right"> </wc-toast>

<div class="flex justify-center items-center min-h-screen bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] bg-cover bg-center">
    <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
        <h2 class="font-bold text-2xl mb-3">Sign Up</h2>
        <p class="mb-7">Enter your email and password to register</p>
        <div class="space-y-5">
            <div>
                <label for="name">Name</label>
                <input id="name" type="text" class="form-input" placeholder="Enter Name" />
            </div>
            <div>
                <label for="email">Email</label>
                <input id="email" type="email" class="form-input" placeholder="Enter Email" />
            </div>

            <div class="relative">
                <label for="password">Password</label>
                <input id="password" type="password" class="form-input" placeholder="Enter Password" />
                <div class="visibility-container text-base text-[#515365] dark:text-white-dark">
                    <i class="fa fa-eye"></i>
                </div>
            </div>
            <div class="relative">
                <!--<input type="hidden" id="refer_id" value="<php echo $_GET['ref_id']; ?>" />     -->
                <label for="confirm_password">Confirm Password</label>
                <input id="confirm_password" type="password" class="form-input" placeholder="Enter Confirm Password" />
                <div class="visibility-container text-base text-[#515365] dark:text-white-dark">
                    <i class="fa fa-eye"></i>
                </div>
            </div>
            <div>
                <label for="token">Token</label>
                <input id="token" type="text" class="form-input" placeholder="Enter Token" />
                <p class="mt-2">Don't Have Token ? <a href="https://t.me/smscheckrbot" target="_blank" class="text-primary font-bold hover:underline">Get Token</a></p>
            </div>
            <div>
                <center>
                    <div class="g-recaptcha" data-sitekey="<?php echo $site_data['captcha_public_key']; ?>"></div>
                </center>
            </div>
            <center><button type="submit" id="register" class="btn btn-primary w-full">Sign Up</button></center>
        </div><br>
        <p class="text-center">Already have an account ? <a href="index" class="text-primary font-bold hover:underline">Sign In</a></p>
    </div>
</div>
<script>
    // PASSWORD VISIBILITY TOGGLER
    $(".visibility-container").each(function(index) {
            $(this).on("click", function() {
                const icon = $(this).children()[0]

                if (icon.getAttribute("class") === "fa fa-eye") {
                    icon.setAttribute("class", "fa fa-eye-slash");

                    $("#password")[index].setAttribute("type", "text");
                } else {
                    icon.setAttribute("class", "fa fa-eye");

                    if (index === 0) {
                        $("#password")[index].setAttribute("type", "password");
                    }
                }
            });
        })
</script>
<?php
include("include/custom_js.php");
?>
<style>
    .float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 40px;
        right: 40px;
        background-color: #0000cd;
        color: #FFF;
        border-radius: 50px;
        text-align: center;
        font-size: 30px;
        box-shadow: 2px 2px 3px #a9a9a9;
        z-index: 100;
    }

    .my-float {
        margin-top: 16px;
    }
</style>

<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<a href="https://wa.me/+2347013549946" class="float" target="_blank">
    <i class="fa fa-comment my-float"></i>
</a>

<?php include 'include/footer-main-auth.php'; ?>