<?php
$page_name = "Profile";
include 'include/header-main.php';
?>
<script>
    $(document).ready(function() {
        // Remove "active" class from all <a> elements
        $('#slide-dashboard').removeClass("active");

        // Add "active" class to the specific element with ID "faq"
        $("#slider-profile").addClass("active");
    });
</script>
<wc-toast id="tt" position="top-center"> </wc-toast>
<script defer src="<?php echo WEBSITE_URL; ?>/theam/otpbus/assets/js/apexcharts.js"></script>
<div x-data="analytics">
    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="javascript:;" class="text-primary hover:underline">Dashboard</a>
        </li>
        <li class="before:content-['/'] before:mr-1 rtl:before:ml-1 ">
            <span>Profile</span>
        </li>
    </ul>

    <div class="panel mt-5">
        <h5 class="font-bold text-lg dark:text-white-light">User Information</h5>
        <div class="grid grid-cols-1 gap-5 mt-2">
            <input type="hidden" id="tokens" value="<?php echo $_SESSION['token']; ?>">
            
            <!-- Name field (readonly) -->
            <div>
                <label for="name" class="form-label">Name</label>
                <input type="text" id="name" value="<?php echo $userdata['name']; ?>" class="form-input" readonly />
            </div>

            <!-- Email field (readonly) -->
            <div>
                <label for="email" class="form-label">Email</label>
                <input type="email" id="email" value="<?php echo $userdata['email']; ?>" class="form-input" readonly />
            </div>

            <!-- Phone number field (editable) -->
            <div>
                <label for="phone_number" class="form-label">Phone Number</label>
                <input type="text" id="phone_number" value="<?php echo $userdata['phone_number']; ?>" class="form-input" />
            </div>
        </div>
        <button type="button" id="save_profile" class="btn btn-primary w-full mt-6">Save Changes</button>
    </div>

    <div class="panel mt-5">
        <h5 class="font-bold text-lg dark:text-white-light">Change Password</h5>
        <div class="grid grid-cols-1 sm:flex justify-between gap-5 mt-2">
            <input type="hidden" id="tokens" value="<?php echo $_SESSION['token']; ?>">
            
            <?php
            if (!empty($userdata['password'])) {
            ?>
                <input type="text" id="old_password" placeholder="Enter Old Password" class="form-input" />
            <?php
            }
            ?>
            <input type="text" id="new_password" placeholder="Enter New Password" class="form-input" />
            <input type="text" id="confirm_password" placeholder="Enter Confirm Password" class="form-input" />
        </div>
        <button type="button" id="change_pass" class="btn btn-primary w-full mt-6">Save</button>
    </div>

    <?php
    include("include/custom_js.php");
    ?>
    <?php include 'include/footer-main.php'; ?>
</div>
