<?php
    $page_name = "Login";
    include 'include/header-main-auth.php';
?>
<wc-toast id="tt" position="top-right"></wc-toast>
<!-- bg-[url('/assets/images/map.svg')] dark:bg-[url('/assets/images/map-dark.svg')] -->
<div class="bg-[url(/assets/images/login_background.jpg)] bg-cover bg-no-repeat h-[360px] fixed top-0 left-0 right-0"></div>
<div class="flex justify-center items-center min-h-screen bg-cover bg-center">
    <div class="panel sm:w-[480px] m-6 max-w-lg w-full">
        <a class="mb-4 block" href="./">
            <img x-cloak x-show="$store.app.theme === 'light'" src="img/temi-light.jpg" alt="Logo" width="100" class="inline-block mr-2">
            <img x-cloak x-show="$store.app.theme === 'dark'" src="img/temi-dark.jpg" alt="Logo" width="100" class="inline-block mr-2">
            <img x-cloak x-show="$store.app.theme === 'system'" src="img/temi-light.jpg" alt="Logo" width="100" class="inline-block mr-2">
            <!--<span style="color: #496fd9;">DigitsDepot</span>-->
        </a>
        <h2 class="font-bold text-3xl mb-3">Sign In</h2>
        <p class="mb-5 text-gray">Enter your email and password to login</p>
        <form id="login-form" class="space-y-5">
            <?php
            if (isset($msg1)) {
            ?>
                <div class="my-2 flex items-center p-3.5 rounded text-danger bg-danger-light dark:bg-danger-dark-light">
                    <span class="ltr:pr-2 rtl:pl-2">
                        <!-- <strong class="ltr:mr-1 rtl:ml-1">Danger!</strong> -->
                        <?php echo $msg1; ?>
                    </span>
                </div>
            <?php
            }
            ?>
            <?php
            if (isset($_GET['success'])) {
            ?>
                <div class="my-2 flex items-center p-3.5 rounded text-success bg-success-light dark:bg-danger-success-light">
                    <span class="ltr:pr-2 rtl:pl-2">
                        <!-- <strong class="ltr:mr-1 rtl:ml-1">Danger!</strong> -->
                        <?php echo $_GET['success'] === "1"? "You have registered successfully. Proceed to login!" : "You have changed your password successfully. Proceed to Login." ?>
                    </span>
                </div>
            <?php
            }
            ?>
            <div>
                <label for="email">Email</label>
                <input id="email" type="email" name="email" class="form-input" placeholder="Enter Email" />
            </div>
            <div class="relative">
                <label for="password">Password</label>
                <input id="password" type="password" name="password" class="form-input" placeholder="Enter Password" />
                <div class="visibility-container text-base text-[#515365] dark:text-white-dark">
                    <i class="fa fa-eye"></i>
                </div>
            </div>
            <div class="text-right">
                <a href="forgot-password" class="text-primary">Forgot Password?</a>
            </div>
            <div>
                <label class="switch mr-2">
                    <input name="remember" type="checkbox">
                    <span class="slider"></span> 
                </label>
                <span class="">Remember Me</span>
            </div>
            <button type="submit" class="btn btn-primary w-full" id="login">Sign In</button>
        </form>
        <!-- <div class="relative my-7 h-5 text-center before:w-full before:h-[1px] before:absolute before:inset-0 before:m-auto before:bg-[#ebedf2] dark:before:bg-[#253b5c] mb-3">
            <div class="font-bold text-white-dark bg-white dark:bg-[#0e1726] px-2 relative z-[1] inline-block"><span>OR</span></div>
        </div> -->
        <!-- <ul class="flex justify-center gap-2 sm:gap-3 mb-7">
            <li>
                <a href="google-login" class="inline-block h-full">
                    <button class="button justify-center h-full">
                        <svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 262">
                            <path fill="#4285F4" d="M255.878 133.451c0-10.734-.871-18.567-2.756-26.69H130.55v48.448h71.947c-1.45 12.04-9.283 30.172-26.69 42.356l-.244 1.622 38.755 30.023 2.685.268c24.659-22.774 38.875-56.282 38.875-96.027"></path>
                            <path fill="#34A853" d="M130.55 261.1c35.248 0 64.839-11.605 86.453-31.622l-41.196-31.913c-11.024 7.688-25.82 13.055-45.257 13.055-34.523 0-63.824-22.773-74.269-54.25l-1.531.13-40.298 31.187-.527 1.465C35.393 231.798 79.49 261.1 130.55 261.1"></path>
                            <path fill="#FBBC05" d="M56.281 156.37c-2.756-8.123-4.351-16.827-4.351-25.82 0-8.994 1.595-17.697 4.206-25.82l-.073-1.73L15.26 71.312l-1.335.635C5.077 89.644 0 109.517 0 130.55s5.077 40.905 13.925 58.602l42.356-32.782"></path>
                            <path fill="#EB4335" d="M130.55 50.479c24.514 0 41.05 10.589 50.479 19.438l36.844-35.974C195.245 12.91 165.798 0 130.55 0 79.49 0 35.393 29.301 13.925 71.947l42.211 32.783c10.59-31.477 39.891-54.251 74.414-54.251"></path>
                        </svg>
                    </button>
                </a>
            </li>
            <li>
                <a href="facebook-login" class="inline-block h-full">
                    <button class="button justify-center h-full">
                        <i class="fa fa-facebook-square fa-2x" style="color: #0866FF;"></i>
                    </button>
                </a>
            </li>
            <li>
                <a href="facebook-login" class="inline-block h-full">
                    <button class="button justify-center h-full">
                        <i class="fa fa-apple fa-2x"></i>
                    </button>
                </a>
            </li>
        </ul> -->
        <p class="text-center mt-5">Don't have an account ? <a href="register" class="text-primary font-bold hover:underline">Sign Up</a></p>
    </div>
</div>
<script>
    // PASSWORD VISIBILITY TOGGLER
    $(".visibility-container").each(function(index) {
            $(this).on("click", function() {
                const icon = $(this).children()[0]

                if (icon.getAttribute("class") === "fa fa-eye") {
                    icon.setAttribute("class", "fa fa-eye-slash");

                    $("#password")[index].setAttribute("type", "text");
                } else {
                    icon.setAttribute("class", "fa fa-eye");

                    if (index === 0) {
                        $("#password")[index].setAttribute("type", "password");
                    }
                }
            });
        })
</script>
<?php 
include("include/custom_js_new.php");
?>
<?php

include 'include/footer-main-auth.php';
?>