<?php
$page_name = "Frequently Asked Questions";
include 'include/header-main.php';
?>
<script src="<?php echo WEBSITE_URL; ?>/theam/otpbus/assets/js/simple-datatables.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
<script defer src="<?php echo WEBSITE_URL; ?>/theam/otpbus/assets/js/apexcharts.js"></script>
<script>
    $(document).ready(function() {
        // Remove "active" class from all <a> elements
        $('#slide-dashboard').removeClass("active");

        // Add "active" class to the specific element with ID "slider-api-tool"
        $("#slider-api-tool").addClass("active");
    });
</script>

<wc-toast id="tt" position="top-center"> </wc-toast>
<script defer src="<?php echo WEBSITE_URL; ?>/theam/otpbus/assets/js/apexcharts.js"></script>
<div x-data="analytics">
    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="javascript:;" class="text-primary hover:underline">Dashboard</a>
        </li>
        <li class="before:content-['/'] before:mr-1 rtl:before:ml-1 ">
            <span>FAQs</span>
        </li>
    </ul>

    <ul class="flex mt-4 space-x-2 rtl:space-x-reverse">
        <li>
            <a class="text-primary text-xl">Frequently Asked Questions</a>
        </li>
    </ul>
    <div class="space-y-5 mt-5" x-data="{ active: null }">
        <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
            <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                <span class="text-primary">What is the SMS verification service?</span>
                <div class="ltr:ml-auto  rtl:mr-auto flex">

                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                        <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </div>
            </div>
            <div x-cloak x-show="active === 1" x-collapse>
                <div class="p-3 font-semibold">
                    <p class="p-2 text-[#515365] dark:text-white-light">
                        Virtual phone number texting service allows you to receive a confirmation code to register on any site that requires you to verify your phone number
                    </p>
                    <p class="p-2 text-[#515365] dark:text-white-light">
                        Thanks to special equipment we have installed in our office and our software, anyone can get a virtual number to receive sms in minutes.
                    </p>
                </div>
            </div>
        </div>
        <div class="space-y-5 mt-5" x-data="{ active: null }">
            <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
                <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                    <span class="text-primary">What is a virtual number?</span>
                    <div class="ltr:ml-auto  rtl:mr-auto flex">

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                            <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                </div>
                <div x-cloak x-show="active === 1" x-collapse>
                    <div class="p-3 font-semibold">
                        <p class="p-2 text-[#515365] dark:text-white-light">
                            A virtual number is a cloud number that has no physical SIM card and is not tied to a specific device or location. An important feature of our online service is that our virtual numbers can only receive SMS but not send them.
                        </p>
                    </div>
                </div>
            </div>
            <div class="space-y-5 mt-5" x-data="{ active: null }">
                <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
                    <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                        <span class="text-primary">Do I need a SIM card to use my virtual number?</span>
                        <div class="ltr:ml-auto  rtl:mr-auto flex">

                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                                <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>
                    <div x-cloak x-show="active === 1" x-collapse>
                        <div class="p-3 font-semibold">
                            <p class="p-2 text-[#515365] dark:text-white-light">
                                No! There is no need, just purchase a number on our website.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="space-y-5 mt-5" x-data="{ active: null }">
                    <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
                        <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                            <span class="text-primary">Will someone have access to my number after my rent is up?</span>
                            <div class="ltr:ml-auto  rtl:mr-auto flex">

                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                                    <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                        </div>
                        <div x-cloak x-show="active === 1" x-collapse>
                            <div class="p-3 font-semibold">
                                <p class="p-2 text-[#515365] dark:text-white-light">
                                    A rented number is available only to you and cannot be sold to anyone else, even after the rental period has ended. We respect our customers, and one number is issued to one customer only!
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="space-y-5 mt-5" x-data="{ active: null }">
                        <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
                            <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                                <span class="text-primary">What does it mean to receive SMS from website online?</span>
                                <div class="ltr:ml-auto  rtl:mr-auto flex">

                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                                        <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </div>
                            <div x-cloak x-show="active === 1" x-collapse>
                                <div class="p-3 font-semibold">
                                    <p class="p-2 text-[#515365] dark:text-white-light">
                                        You buy a virtual phone number for a specific service and when you register you need a code to confirm the number, you get it from our website.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="space-y-5 mt-5" x-data="{ active: null }">
                            <div class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md bg-white dark:bg-[#0e1726] ">
                                <div class="flex font-semibold p-5 rounded-t-md  cursor-pointer" :class="{'bg-primary/20 text-primary' : active === 1}" x-on:click="active === 1 ? active = null : active = 1">
                                    <span class="text-primary">What do I do if I can't buy a virtual number?</span>
                                    <div class="ltr:ml-auto  rtl:mr-auto flex">

                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" :class="{ 'rotate-180': active === 1 }">
                                            <path d="M19 9L12 15L5 9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                </div>
                                <div x-cloak x-show="active === 1" x-collapse>
                                    <div class="p-3 font-semibold">
                                        <p class="p-2 text-[#515365] dark:text-white-light">
                                            Unfortunately, sometimes phone numbers may run out of stock. Please wait for replenishment of numbers.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <?php include 'include/footer-main.php'; ?>