<?php
$page_name = "Dashboard";
include 'include/header-main.php';
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script defer src="<?php echo WEBSITE_URL; ?>/theam/otpbus/assets/js/apexcharts.js"></script>
<div>
    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="javascript:;" class="text-primary hover:underline">Dashboard</a>
        </li>
        <li class="before:content-['/'] before:mr-1 rtl:before:ml-1 ">
            <span>Home</span>
        </li>
    </ul>
    <!--    <div class="panel p-3 flex items-center text-primary overflow-x-auto whitespace-nowrap mt-3">
            <div class="ring-2 ring-primary/30 rounded-full bg-primary text-white p-1.5 ltr:mr-3 rtl:ml-3">

                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-3.5 h-3.5">
                    <path d="M19.0001 9.7041V9C19.0001 5.13401 15.8661 2 12.0001 2C8.13407 2 5.00006 5.13401 5.00006 9V9.7041C5.00006 10.5491 4.74995 11.3752 4.28123 12.0783L3.13263 13.8012C2.08349 15.3749 2.88442 17.5139 4.70913 18.0116C9.48258 19.3134 14.5175 19.3134 19.291 18.0116C21.1157 17.5139 21.9166 15.3749 20.8675 13.8012L19.7189 12.0783C19.2502 11.3752 19.0001 10.5491 19.0001 9.7041Z" stroke="currentColor" stroke-width="1.5" />
                    <path opacity="0.5" d="M7.5 19C8.15503 20.7478 9.92246 22 12 22C14.0775 22 15.845 20.7478 16.5 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                </svg>
            </div>
            <span class="ltr:mr-3 rtl:ml-3">Join Telegram For Latest Updates </span><a href="<?php echo $site_data['channel_url']; ?>" target="_blank"><button type="button" class="btn btn-primary btn-sm">Join Now</button></a>
        </div> -->


    <div class="pt-5">
        <div class="grid gap-3 sm:grid-cols-1 md:grid-cols-2">
            <div class="border bg-white rounded dark:bg-[#1b2e4b] dark:border-0 shadow-sm">
                <div class="flex items-center justify-between p-4 py-2">
                    <div class="text-5xl grid place-content-center w-16 h-16 rounded-md bg-primary-light dark:bg-primary text-primary dark:text-primary-light">
                        <i class="bx bx-wallet-alt"></i>
                    </div>
                    <div class="ltr:ml-4 rtl:mr-4 flex items-center justify-between flex-auto font-semibold">
                        <h6 class="text-white-dark text-[13px] dark:text-white-dark">
                            Wallet Balance
                            <span class="block text-xl text-[#515365] dark:text-white-light">₦<?php echo number_format($data['balance'],0,'.',','); ?></span>
                        </h6>
                        <a href="recharge" class="btn btn-sm btn-primary inline-block rounded-sm text-white">Recharge</a>
                    </div>
                </div>
            </div>
            <?php if($userbankaccount !== null): ?>
            <div class="border bg-white rounded dark:bg-[#1b2e4b] dark:border-0 shadow-sm">
                <div class="flex items-center justify-between p-4 py-2">
                    <div class="text-5xl grid place-content-center w-16 h-16 rounded-md bg-success-light dark:bg-success text-success dark:text-success-light">
                        <i class="bx bxs-bank"></i>
                    </div>
                    <div class="ltr:ml-4 rtl:mr-4 flex items-center justify-between flex-auto font-semibold">
                        <h6 class="text-white-dark text-[13px] dark:text-white-dark">
                            Display Virtual Account
                            <span class="block text-md lg:text-xl text-[#515365] dark:text-white-light">Click to show</span>
                        </h6>
                        <button id="viewAccountBtn" class="btn btn-sm btn-primary inline-block rounded-sm text-white">Show Account</button>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="border bg-white rounded dark:bg-[#1b2e4b] dark:border-0 shadow-sm">
                <div class="flex items-center justify-between p-4 py-2">
                    <div class="text-5xl grid place-content-center w-16 h-16 rounded-md bg-success-light dark:bg-success text-success dark:text-success-light">
                        <i class="bx bxs-bank"></i>
                    </div>
                    <div class="ltr:ml-4 rtl:mr-4 flex items-center justify-between flex-auto font-semibold">
                        <h6 class="text-white-dark text-[13px] dark:text-white-dark">
                            Generate Virtual Account
                            <span class="block text-md lg:text-xl text-[#515365] dark:text-white-light">Click to generate</span>
                        </h6>
                        <button id="generateAccountBtn" class="btn btn-sm btn-primary inline-block rounded-sm text-white">Generate Account</button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="border bg-white rounded dark:bg-[#1b2e4b] dark:border-0 shadow-sm">
                <div class="flex items-center justify-between p-4 py-2">
                    <div class="text-5xl grid place-content-center w-16 h-16 rounded-md bg-warning-light dark:bg-warning text-warning dark:text-warning-light">
                        <i class="bx bx-cart-alt"></i>
                    </div>
                    <div class="ltr:ml-4 rtl:mr-4 flex items-center justify-between flex-auto font-semibold">
                        <h6 class="text-white-dark text-[13px] dark:text-white-dark">
                            SMS Purchased - Lifetime
                            <span class="block text-xl text-[#515365] dark:text-white-light"><?php echo $data['total_otp']; ?></span>
                        </h6>
                        <a href="numbers" class="btn btn-sm btn-primary inline-block rounded-sm text-white"><i class="bx bx-xs bx-arrow-from-left"></i></a>
                    </div>
                </div>
            </div>
            <div class="border bg-white rounded dark:bg-[#1b2e4b] dark:border-0 shadow-sm">
                <div class="flex items-center justify-between p-4 py-2">
                    <div class="text-5xl grid place-content-center w-16 h-16 rounded-md bg-secondary-light dark:bg-secondary text-secondary dark:text-secondary-light">
                        <i class="bx bx-history"></i>
                    </div>
                    <div class="ltr:ml-4 rtl:mr-4 flex items-center justify-between flex-auto font-semibold">
                        <h6 class="text-white-dark text-[13px] dark:text-white-dark">
                            Total Recharge
                            <span class="block text-xl text-[#515365] dark:text-white-light">₦<?php echo number_format($data['total_recharge'],0,'.',','); ?></span>
                        </h6>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- <div class="pt-5">
            <div class="panel h-full overflow-hidden before:bg-[#db6a00] before:absolute before:-right-44 before:top-0 before:bottom-0 before:m-auto before:rounded-full before:w-96 before:h-96 grid grid-cols-1 content-between" style="background:linear-gradient(0deg,#FFA500 -227%,#fd7e14)!important;">
                <div class="flex items-start justify-between text-white-light mb-16 z-[7]">
                    <h5 class="font-semibold text-lg">Available Balance :</h5>

                    <div class="relative text-xl whitespace-nowrap">
                        ₦<?php echo $data['balance']; ?>
                    </div>
                </div>
                <div class="flex items-center justify-between z-10">
                    <div class="flex items-center justify-between">
                        <a href="recharge" class="shadow-[0_0_2px_0_#bfc9d4] rounded p-1 text-white-light hover:bg-[#ffa500] place-content-center ltr:mr-2 rtl:ml-2">
                            <svg class="w-5 h-5" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                <line x1="5" y1="12" x2="19" y2="12"></line>
                            </svg>
                        </a>
                        <a href="transactions" class="shadow-[0_0_2px_0_#bfc9d4] rounded p-1 text-white-light hover:bg-[#ffa500] grid place-content-center">
                            <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                <path opacity="0.5" d="M10 16H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path opacity="0.5" d="M14 16H12.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path opacity="0.5" d="M2 10L22 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                            </svg>
                        </a>
                    </div>
                    <a href="buy-number" class="shadow-[0_0_2px_0_#bfc9d4] rounded p-1 text-white-light hover:bg-[#ffa500] z-10">
                        Buy Number
                    </a>
                </div>
            </div>

        </div> -->

    <br>

    <div class="grid sm:grid-cols-1 md:grid-cols-2 gap-4">
        <div class="panel panel dashboard-panel">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="font-semibold text-lg dark:text-white-light">Number Purchase History</h5>
                <a href="numbers" class="text-primary hover:underline">View All</a>
            </div>
            <div class="space-y-4 max-h-80 overflow-x-auto px-2">
                <?php
                if ($recent_numbers) {
                    $i = 1;
                    foreach ($recent_numbers as $number) {
                        // print_r($number);
                        // $timestamp = strtotime($number['date']);
                        // $formattedDate = date("M d, Y - h:i A", $number);
                        $formattedDate = $number['date'];

                        if($number['sms_text'] !== ""){
                ?>
                    <div class="border border-[#ebedf2] rounded dark:bg-[#1b2e4b] dark:border-0">
                        <div class="flex items-center justify-between p-4 py-2">
                            <div class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light">
                                <i class="bx bx-sm bx-check"></i>
                            </div>
                            <div class="ltr:ml-4 rtl:mr-4 flex items-start justify-between flex-auto font-semibold">
                                <h6 class="font-semibold text-base dark:text-white-light">
                                    <?php echo $number['service_name'] . " (" .  $number['server_name'] . ")"  ?>;
                                    <span class="block text-base text-[#515365] text-[13px] dark:text-white-dark"><?php echo $number['number'] ?></span>
                                    <span class="block text-base text-[#515365] text-[13px] dark:text-white-dark">OTP: <?php echo $number['sms_text'] ?></span>
                                </h6>
                            </div>
                        </div>
                    </div>
                    <?php
                        }else{
                    ?>
                    <div class="border border-[#ebedf2] rounded dark:bg-[#1b2e4b] dark:border-0">
                        <div class="flex items-center justify-between p-4 py-2">
                            <div class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light">
                                <i class="bx bx-sm bx-block"></i>
                            </div>
                            <div class="ltr:ml-4 rtl:mr-4 flex items-start justify-between flex-auto font-semibold">
                                <h6 class="font-semibold text-base dark:text-white-light">
                                    <?php echo $number['service_name'] . " (" .  $number['server_name'] . ")"  ?>;
                                    <span class="block text-base text-[#515365] text-[13px] dark:text-white-dark"><?php echo $number['number'] ?></span>
                                    <span class="block text-base text-[#515365] text-[13px] dark:text-white-dark">OTP Not Received</span>
                                </h6>
                            </div>
                        </div>
                    </div>
                <?php
                        }
                    }
                    $i++;
                } else {
                ?>
                    <p class="dark:text-white-light"> No Recent Numbers Yet.</p>
                <?php
                }
                ?>
            </div>
        </div>
        <!-- Recent Transactions -->
        <div class="panel dashboard-panel">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="font-semibold text-lg dark:text-white-light">Recent Transactions</h5>
                <a href="transactions" class="text-primary hover:underline">View All</a>
            </div>
            <div class="space-y-5 max-h-80 overflow-x-auto px-2">
                <?php
                if ($recent_history) {
                    $i = 1;
                    foreach ($recent_history as $transaction) {
                        if ($transaction['status'] == "1") {
                            $img = '<span class="badge bg-success/20 text-success rounded-full absolute top-2 right-2">Success</span>';
                        } elseif ($transaction['status'] == "2") {
                            $img = '<span class="badge bg-warning/20 text-warning rounded-full absolute top-2 right-2">Pending</span>';
                        } else {
                            $img = '<span class="badge bg-danger/20 text-danger rounded-full absolute top-2 right-2">Failed</span>';
                        }
                        $timestamp = strtotime($transaction['date']);
                        $formattedDate = date("M d, Y - h:i A", $timestamp);

                        if ($transaction['type'] !== "Manual") {
                            // GATEWAY PAYMENT
                ?>
                            <div class="p-4 bg-primary-light dark:bg-[#1b2e4b] rounded-lg shadow-sm relative">
                                <?php echo $img; ?>
                                <h2 class="mb-2 font-semibold text-base dark:text-white-light"><?php echo $transaction['type'] ?> Payment</h2>
                                <div class="space-y-2">
                                    <p><b class="dark:text-white-light mr-2">Type:</b> Gateway Payment.</p>
                                    <p><b class="dark:text-white-light mr-2">Amount:</b> NGN <?php echo number_format((float) $transaction['amount'],0,'.',','); ?></p>
                                    <p><b class="dark:text-white-light mr-2">Date:</b> <?php echo $formattedDate ?></p>
                                </div>
                            </div>
                        <?php
                        } else {
                        ?>
                            <div class="p-4 bg-primary-light dark:bg-[#1b2e4b] rounded-lg shadow-sm relative">
                                <?php echo $img; ?>
                                <h2 class="mb-2 font-semibold text-base dark:text-white-light">Manual Credit</h2>
                                <div class="space-y-2">
                                    <p><b class="dark:text-white-light mr-2">Amount:</b> NGN <?php echo number_format($transaction['amount'],0,'.',','); ?></p>
                                    <p><b class="dark:text-white-light mr-2">Date:</b> <?php echo $formattedDate ?></p>
                                </div>
                            </div>
                    <?php
                        }
                        $i++;
                    }
                } else {
                    ?>
                    <p class="dark:text-white-light"> No Recent Transactions Yet.</p>
                <?php
                }
                ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal header -->
<div x-data="modal(false)" x-init="$store.app.howto == 'no' && setTimeout(() => open = !open, 2000)">
    <div x-show="open" class="overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 flex justify-center items-center w-full md:inset-0 h-full bg-black bg-black/10">
        <div  @click.outside="open = false; $store.app.updateHowTo()" class="relative p-4 w-full max-w-[580px] max-h-full animate__animated animate__zoomIn">
            <div class="bg-white dark:bg-[#1b2e4b] rounded-lg shadow-lg w-full mx-auto">
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 dark:text-white-light">
                    <h3 class="text-xl font-semibold">
                        <img class="ltr:-ml-1 rtl:-mr-1 inline mr-2" src="img/temi.jpg" alt="image" width="100" /><br>
                        Welcome to Tmpverify!!
                    </h3>
                    <button x-on:click="open = !open; $store.app.updateHowTo()" type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-4 md:p-5 space-y-2 text-sm text-gray-700 dark:text-white-light">
                    <!--<div class="w-full">-->
                    <!--<iframe src="https://www.youtube.com/embed/IUiuvibDu6s?rel=0" style="top: 0; left: 0; width: 90%; height: 170%; position: absolute; border: 0;" allowfullscreen scrolling="no" allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share;"></iframe>-->
                    <!--</div>-->
                     <p>
                        <strong>Join Our Whatsapp Chanel</strong><br>
                        <a href="#" class="inline-block text-primary dark:text-white-light fw-bold">Join Channel</a>
                    </p>
                    <p>
                        <strong>How to Buy SMS Units</strong><br>
                        Go to the dashboard and click on the "Buy SMS" option. Choose your preferred payment method and follow the instructions to complete the purchase.
                    </p>
    
                    <p>
                        <strong>Creating Virtual Account</strong><br>
                        If you create virtual account, you can use it as your payment method, Any money you sent to it will automatically reflect on your dashboard (Min: N100).
                    </p>
    
                    <p>
                        <strong>SMS Costs</strong><br>
                        Our SMS Verification prices are cheap and affordable for all users, resellers, get started today.
                    </p>
                    <!--<h2 class="text-xl font-semibold dark:text-white-light">How To Verify With Ebuce SMS Verify.</h2>-->
                    <!--<p class="text-gray-600 dark:text-white-light">Watch a sample video of how to use our product.</p>-->
                </div>
            </div>
        </div>
    </div>
    <button x-on:click="open = !open" class="bg-primary rounded-full p-3 text-white font-semibold how-to-float shadow-sm">
       <div class="flex gap-1 justify-center items-center">
            <i x-show="open" class='bx bx-sm bx-x'></i>
            <i x-show="!open" class='bx bx-sm bx-question-mark'></i>
            <span class="text-sm">Help</span>
        </div>
    </button>
</div>

<style>
    body.mobile-app-view .float {
        display: none;
    }

    .float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 80px;
        right: 40px;
        background-color: rgb(73 111 217);
        color: #FFF;
        border-radius: 50px;
        text-align: center;
        font-size: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
        z-index: 100;
    }
    
    .how-to-float{
        position: fixed;
        bottom: 80px;
        right: 40px;
    }
</style>
<!--
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<a href="https://wa.me/message/LGFRUCPVSM66M1" class="float" target="_blank">
    <i class="fa fa-comment my-float"></i>
</a> -->
<div id="accountModal" class="hidden fixed top-0 left-0 w-full h-full bg-black bg-opacity-50 flex justify-center items-center z-50" onclick="closeModal(event)">
    <div class="bg-white p-6 rounded shadow-md max-w-lg w-full">
        <h3 class="text-xl font-semibold">Bank Account Details</h3>
        <p class="text-md">Send money to this account to top-up your wallet easily</h3>
        <div id="accountDetails" class="mt-4">
            <?php 
                if($userbankaccount !== null){
                    echo '
                    <p class="mb-2"><strong>Account Number:</strong> '. $userbankaccount['account_number'] .'</p>
                    <p class="mb-2"><strong>Bank Name:</strong> '. $userbankaccount['bank_name'] .'</p>
                    <p><strong>Account Name:</strong> '. $userbankaccount['account_name'] .'</p>';
                }
            ?>
            <!-- Account details will be displayed here -->
        </div>
        <button id="closeModalBtn" class="mt-4 btn btn-info">Close</button>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
<script>
    // var notyf = new Notyf({
    //     duration: 5000,
    //     position: {x:'right',y:'top'},
    //     ripple: true,
    //     dismissible: true
    // });
    var notyf = new Notyf();
    const generateAccountBtn = document.getElementById('generateAccountBtn');
    const viewAccountBtn = document.getElementById('viewAccountBtn');
    const accountModal = document.getElementById('accountModal');
    const closeModalBtn = document.getElementById('closeModalBtn');
    const accountDetails = document.getElementById('accountDetails');
    
    closeModalBtn.addEventListener('click', () => {
        accountModal.classList.add('hidden');
    });
    
    function closeModal(event) {
        if (event.target === document.getElementById("accountModal")) {
            document.getElementById("accountModal").classList.add("hidden");
        }
    }
    
    if(viewAccountBtn){
        viewAccountBtn.addEventListener('click', () => {
            accountModal.classList.remove('hidden');
        });
    }
    
    if(generateAccountBtn){
        generateAccountBtn.addEventListener('click', () => {
        $("#generateAccountBtn").prop("disabled", true);
        $("#generateAccountBtn").html('<span class="animate-spin border-2 border-white border-l-transparent rounded-full w-4 h-4 ltr:mr-1 rtl:ml-1 inline-block align-middle"></span> Generating...');

        $.ajax({
            type: "POST",
            url: "api/paymentpoint/generate_bank_account.php",// PHP script URL
            data: {
                token: "<?php echo $_SESSION['token'] ?>"
            },
            error: function (e) {
                notyf.error({
                    message: 'An error occurred during processing.',
                    duration: 5000,
                    position: {x:'right', y:'top'}
                });
                $("#generateAccountBtn").html("Generate Account");
                $("#generateAccountBtn").prop("disabled", false);
            },
            success: function (data) {
                $("#generateAccountBtn").html("Generate Account");
                $("#generateAccountBtn").prop("disabled", false);
                var json = JSON.parse(data);
                if (json.status === "1") {
                    notyf.success({
                        message: json.msg,
                        duration: 5000,
                        position: {x:'right', y:'top'}
                    });
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                } else {
                    notyf.error({
                        message: json.msg,
                        duration: 5000,
                        position: {x:'right', y:'top'}
                    });
                }
            },
        });
    });
    }
    
    <?php
    if (isset($_SESSION['success_message'])) {
        echo "notyf.success({
        message: '" . $_SESSION['success_message'] . "',
      duration: 5000,
      position: {x:'right',y:'top'}});";
        unset($_SESSION['success_message']);
    }
    if (isset($_SESSION['error_message'])) {
        echo "notyf.error({
      message: '" . $_SESSION['error_message'] . "',
      duration: 5000,
      position: {x:'right',y:'top'} 
      });";
        unset($_SESSION['error_message']);
    }
    ?>
</script>
<style>
    /* Styles for Modal and Button */
    #accountModal {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: 50;
    }

    #accountModal .bg-white {
        width: 400px;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    #accountModal .btn-primary {
        background-color: #007bff;
        color: white;
    }
    
    #accountModal .btn-secondary {
        background-color: #6c757d;
        color: white;
    }
</style>
<?php include 'include/footer-main.php'; ?>