<?php
include("auth.php");
if(!isset($_SESSION['token'])){
	if(isset($_COOKIE['remember_me'])) {
		$radium_token = $_COOKIE['remember_me'];
		$_SESSION['token'] = $radium_token;
	}else{
	header('location: login');
    exit;
	}
}
$sql = mysqli_query($conn, "SELECT * FROM user_transaction WHERE type = 'Manual' ORDER BY id DESC");

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manual Payments - @radiumsahil</title>
    <?php include("include/head.php"); ?>
    <link href="vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

</head>
<script>
    $(document).ready(function() {
        // Remove "active" class from all <a> elements
        $('#dashboard').removeClass("active");

        // Add "active" class to the specific element with ID "faq"
        $("#manual_transactions").addClass("active");
    });
</script>

<body id="page-top">
    <div id="wrapper">
        <!-- Sidebar -->
        <?php include("include/slidebar.php"); ?>
        <!-- Sidebar -->
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <!-- TopBar -->
                <?php include("include/topbar.php"); ?>
                <!-- Topbar -->

                <!-- Container Fluid-->
                <div class="container-fluid" id="container-wrapper">
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Manual Payments</li>
                        </ol>
                    </div>

                    <!---Container Fluid-->
                    <!-- Row -->
                    <div class="row">
                        <!-- Datatables -->
                        <div class="col-lg-12">
                            <div class="card mb-4">
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary">Recent 200 Transaction</h6>
                                </div>
                                <div class="table-responsive p-3">
                                    <table class="table align-items-center table-flush" id="dataTable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Email</th>
                                                <th>Amount</th>
                                                <th>Txn_id</th>
                                                <th>Receipt</th>
                                                <th>Time</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $i = 1;
                                            while ($data = mysqli_fetch_array($sql)) {
                                                $user_id = $data['user_id'];
                                                $sql2 = mysqli_query($conn, "SELECT * FROM user_data WHERE id='" . $user_id . "'");
                                                $sql3 = mysqli_fetch_assoc($sql2);
                                                if ($data['status'] == "1") {
                                                    $status = "badge badge-success";
                                                    $status1 = "Approved";
                                                } elseif ($data['status'] == "2") {
                                                    $status = "badge badge-warning";
                                                    $status1 = "Pending";
                                                } else {
                                                    $status = "badge badge-danger";
                                                    $status1 = "Rejected";
                                                }
                                            ?>
                                                <tr>
                                                    <td><?php echo $sql3['email']; ?></td>
                                                    <td><?php echo $data['amount']; ?></td>
                                                    <td><?php echo $data['txn_id']; ?></td>
                                                    <td><a href="../manual-requests/<?php echo $data['receipt']; ?>">view receipt</a></td>
                                                    <td><?php echo $data['date']; ?></td>
                                                    <td><span class="<?php echo $status; ?>"><?php echo $status1; ?></span></td>
                                                    <td>
                                                        <button class="btn btn-success approve-btn" data-id="<?= $data['id'] ?>" <?= $status1 !== "Pending"? 'disabled' : "" ?>>Approve</button>
                                                        <button class="btn btn-danger reject-btn" data-id="<?= $data['id'] ?>" <?= $status1 !== "Pending"? 'disabled' : "" ?>>Reject</button>
                                                    </td>
                                                </tr>
                                            <?php
                                                $i++;
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- Footer -->
                    <?php include("include/copyright.php"); ?>
                    <!-- Footer -->
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="actionModal" tabindex="-1" role="dialog" aria-labelledby="actionModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="actionModalLabel">Confirm Action</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            Are you sure you want to <span id="actionText"></span> this credit request?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" id="confirmAction">
                                Confirm
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Scroll to top -->
            <a class="scroll-to-top rounded" href="#page-top">
                <i class="fas fa-angle-up"></i>
            </a>
            <?php include("include/script.php"); ?>
            <!-- Page level plugins -->
            <script src="vendor/datatables/jquery.dataTables.min.js"></script>
            <script src="vendor/datatables/dataTables.bootstrap4.min.js"></script>
            <script>
                $(document).ready(function() {
                     $('#dataTable').DataTable({
                        "order": [] // This disables any default sorting
                    }); // ID From dataTable 
                    $('#dataTableHover').DataTable(); // ID From dataTable with Hover
                });
            </script>
            <script>
                $(document).ready(function() {
                    let currentAction;
                    let currentId;
                    let currentRow;

                    $('#dataTable').on('click', '.approve-btn, .reject-btn', function() {
                        currentId = $(this).data('id');
                        currentAction = $(this).hasClass('approve-btn') ? 'approve' : 'reject';
                        currentRow = $(this).closest('tr');

                        $('#actionText').text(currentAction);
                        $('#actionModal').modal('show');
                    });

                    $('#confirmAction').on('click', function() {
                        if (currentAction === 'approve') {
                            currentRow.find('.badge').text('Approved');
                            currentRow.find('.badge').attr('class', 'badge badge-success');
                            currentRow.find('.approve-btn').prop('disabled', true);
                            currentRow.find('.reject-btn').prop('disabled', true);
                        } else {
                            currentRow.find('.badge').text('Rejected');
                            currentRow.find('.badge').attr('class', 'badge badge-danger');
                            currentRow.find('.approve-btn').prop('disabled', true);
                            currentRow.find('.reject-btn').prop('disabled', true);
                        }
                        $('#actionModal').modal('hide');
                    });

                    $('#confirmAction').on('click', function() {
                        const spinner = $(this).find('.spinner-border');
                        spinner.show();
                        $(this).prop('disabled', true);

                        $.ajax({
                            url: 'ajax/update_manual_payment.php',
                            type: 'POST',
                            data: {
                                id: currentId,
                                action: currentAction
                            },
                            success: function(response) {
                                if (currentAction === 'approve') {
                                    currentRow.find('.badge').text('Approved');
                                    currentRow.find('.badge').attr('class', 'badge badge-success');
                                } else {
                                    currentRow.find('.badge').text('Rejected');
                                    currentRow.find('.badge').attr('class', 'badge badge-danger');
                                }
                                currentRow.find('.approve-btn, .reject-btn').prop('disabled', true);
                            },
                            error: function(xhr, status, error) {
                                alert('An error occurred: ' + error);
                            },
                            complete: function() {
                                spinner.hide();
                                $('#confirmAction').prop('disabled', false);
                                $('#actionModal').modal('hide');
                            }
                        });
                    });
                });
            </script>
</body>

</html>