<?php
require_once __DIR__ . '/include/config.php';
if (isset($_SESSION['token'])) {
    header('location: dashboard');
}

// Check if the remember me cookie exists
if (isset($_COOKIE['remember_me'])) {
    $remember_token = $_COOKIE['remember_me'];

    // Look up the remember token in the database
    $stmt = $conn->prepare('SELECT * FROM login_token WHERE remember_token = ?');
    $stmt->execute([$remember_token]);
    $user = $stmt->fetch();

    if ($user) {
        // Log the user in
        $_SESSION['token'] = $user['token'];

        // Redirect to the dashboard
        header('Location: dashboard.php');
        exit;
    }
}

$token = $_GET['token'] ?? '';

if (empty($token)) {
    header('Location: ./');
}

// Current time
$current_time = time();
$current_datetime = date("Y-m-d H:i:s", $current_time);

// SQL query to verify token and check expiration
$sql = "SELECT * FROM password_resets WHERE token = ? AND expires_at > ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $token, $current_datetime);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

if ($result->num_rows > 0) {
    $email = $data['email'];
} else {
    header("Location: ./");
}

include_once __DIR__ . '/theam/' . THEME . '/reset-password.php';
