<?php
require_once __DIR__ . '/include/config.php';

if(isset($_SESSION['token'])){
	header('location: dashboard');
}

// Check if the remember me cookie exists
if (isset($_COOKIE['remember_me'])) {
    $remember_token = $_COOKIE['remember_me'];

    // Look up the remember token in the database
    $stmt = $conn->prepare('SELECT * FROM login_token WHERE token = ?');
	$stmt->bind_param("s", $remember_token);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    if ($result->num_rows > 0) {
        // Log the user in
        $_SESSION['token'] = $data['token'];

        // Redirect to the dashboard
        header('Location: dashboard.php');
        exit;
    }
}

if(isset($_GET['msg'])){
	$error_data = $_GET['msg'];
	if($error_data=="exists"){
		$msg1="This Account is already Registered. Proceed to <a style='text-decoration: underline;' href='login'>Login</a>.";
	}else if($error_data=="error"){
		$msg1="There was an error processing your request.";
	}
}
include_once __DIR__ . '/theam/' . THEME . '/register-new.php';
?>