<?php
require_once __DIR__ . '/include/config.php';

// Check if the remember me cookie exists
if (isset($_COOKIE['remember_me'])) {
    $remember_token = $_COOKIE['remember_me'];

    // Look up the remember token in the database
    // Look up the remember token in the database
    $stmt = $conn->prepare('SELECT * FROM login_token WHERE token = ?');
	$stmt->bind_param("s", $remember_token);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    if ($result->num_rows > 0) {
        // Log the user in
        $_SESSION['token'] = $data['token'];
    }
}

if (isset($_SESSION['token'])) {
    $userLoggedIn = true;
    $wallet = new radiumsahil();
    $userdata = $wallet->userdata();
} else {
    $userLoggedIn = false;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>Privacy and Policy - DigitDepot</title>
    <link rel="icon" type="home/image/x-icon" href="/images/logo.png" />
    <!-- Bootstrap icons-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.gstatic.com" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Newsreader:ital,wght@0,600;1,600&amp;display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,300;0,500;0,600;0,700;1,300;1,500;1,600;1,700&amp;display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,400;1,400&amp;display=swap" rel="stylesheet" />
    <!-- Core theme CSS (includes Bootstrap)-->
    <link href="Lmg/style.css" rel="stylesheet" />
</head>

<body id="page-top">
    <!-- Navigation-->
    <!-- Navigation-->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top border-bottom" id="mainNav">
        <div class="container">
            <a class="navbar-brand me-4" href="#page-top">
                <img src="img/digitshub_logo.png" alt="Logo Image" width="40" />
                <span class="fs-6" style="color: #496fd9;">DigitsDepot</span>
            </a>
            <div class="justify-content-lg-center order-2 collapse navbar-collapse" id="navbarResponsive">
                <ul class="navbar-nav my-3 my-lg-0">
                    <li class="nav-item me-2">
                        <a class="nav-link" href="./">Home</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="./#about-us">About Us</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="./#contact-us">Contact Us</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="./#features">How to Use</a>
                    </li>
                </ul>

                <?php
                if (!$userLoggedIn) {
                ?>
                    <ul class="nav justify-content-lg-end d-lg-none">
                        <li class="nav-item">
                            <a class="nav-link" href="login">Login</a>
                        </li>
                        <li class="nav-item">
                            <a href="register" class="btn btn-primary text-white">
                                Sign Up
                            </a>
                        </li>
                    </ul>
                <?php
                }
                ?>
            </div>
            <div class="d-flex align-items-center order-1 order-lg-3">
                <?php
                if ($userLoggedIn) {
                ?>
                    <ul class="nav justify-content-lg-end mr-2">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" data-bs-target="#profileDropdown" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="bi bi-person fs-4"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="profileDropdown">
                                <a class="dropdown-item" href="dashboard">Dashboard</a>
                                <a class="dropdown-item" href="recharge">Recharge</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="buy-number">Buy Number</a>
                            </div>
                        </li>
                    </ul>
                <?php
                }
                ?>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                    <i class="bi-list"></i>
                </button>
                <?php
                if (!$userLoggedIn) {
                ?>
                    <ul class="nav justify-content-lg-end d-none d-lg-flex">
                        <li class="nav-item">
                            <a class="nav-link" href="login">Login</a>
                        </li>
                        <li class="nav-item">
                            <a href="register" class="btn btn-primary text-white">
                                Sign Up
                            </a>
                        </li>
                    </ul>
                <?php
                }
                ?>
            </div>
        </div>
    </nav>

    <!-- Basic features section-->
    <section>
        <div class="container-fluid p-5">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <h2 class="display-4 lh-1 mb-4">Privacy and Policy </h2>
                    <p class="lead text-muted mb-4">Your privacy is important to us. This Privacy Policy outlines how we collect, use, and protect your personal information.</p>

                    <p>1. Information Collection</p>
                    <p>We collect information that you provide to us voluntarily, including personal details such as name, email, and phone number.</p>

                    <p>2. Use of Information</p>
                    <p>We use the collected information for providing and improving our services, as well as for communication with you.</p>

                    <p>3. Data Security</p>
                    <p>We implement measures to protect your data, but no method of transmission over the internet or electronic storage is 100% secure.</p>

                    <p>4. Cookies</p>
                    <p>We use cookies to enhance your experience on our website. You can choose to disable cookies through your browser settings.</p>

                    <p>5. Third-Party Links</p>
                    <p>Our website may contain links to third-party sites. We have no control over their content or privacy policies.</p>

                    <p>6. Changes to Policy</p>
                    <p>We reserve the right to update or change this Privacy Policy at any time. Check this page for the latest information.</p>

                    <p>7. Contact Information</p>
                    <p>If you have any questions or concerns regarding this Privacy Policy, please contact us.</p>

                    <p>Thank you for trusting us with your information.</p>

                </div>
            </div>
        </div>
    </section>

    <!-- Call to action section-->

    <!-- Feedback Modal-->
    <section class="pt-0">
        <div class="container">
            <div class="title text-center">
                <h2 class="display-5 lh-1 mb-4 fw-semibold">
                    Have any Questions?
                </h2>
                <p class="fs-6">Please Fill the form below if you have any questions..</p>
            </div>
            <div class="p-4">
                <form id="contactForm" class="needs-validation" novalidate>
                    <!-- Name input-->
                    <div class="form-floating mb-3">
                        <input class="form-control" id="name" type="text" placeholder="Enter your name..." required />
                        <label for="name">Full name</label>
                        <div class="invalid-feedback">A full name is required.</div>
                    </div>
                    <!-- Email address input -->
                    <div class="form-floating mb-3">
                        <input class="form-control" id="email" type="email" placeholder="name@example.com" required />
                        <label for="email">Email address</label>
                        <div class="invalid-feedback">Email is not valid.</div>
                    </div>
                    <!-- Phone number input-->
                    <div class="form-floating mb-3">
                        <input class="form-control" id="phone" type="tel" placeholder="(123) 456-7890" />
                        <label for="phone">Phone number</label>
                    </div>
                    <!-- Message input-->
                    <div class="form-floating mb-3">
                        <textarea class="form-control" id="message" type="text" placeholder="Enter your message here..." style="height: 10rem" required></textarea>
                        <label for="message">Message</label>
                        <div class="invalid-feedback" data-sb-feedback="message:required">A message is required.</div>
                    </div>
                    <!-- Submit success message -->
                    <!-- This is what your users will see when the form-->
                    <!-- has successfully submitted-->
                    <div class="d-none" id="submitSuccessMessage">
                        <div class="text-center mb-3">
                            <div class="fw-bolder">Form submission successful!</div>
                        </div>
                    </div>
                    <!-- Submit error message-->
                    <!---->
                    <!-- This is what your users will see when there is-->
                    <!-- an error submitting the form-->
                    <div class="d-none" id="submitErrorMessage">
                        <div class="text-center text-danger mb-3">Error sending message!</div>
                    </div>
                    <!-- Submit Button-->
                    <div class="d-grid">
                        <button class="btn btn-primary rounded-pill btn-lg" id="submitButton" type="submit">Submit</button>
                    </div>
                </form>
                <script>
                    // Example starter JavaScript for disabling form submissions if there are invalid fields
                    (function() {
                        'use strict';
                        window.addEventListener('load', function() {
                            // Fetch all the forms we want to apply custom Bootstrap validation styles to
                            var forms = document.getElementsByClassName('needs-validation');
                            // Loop over them and prevent submission
                            var validation = Array.prototype.filter.call(forms, function(form) {
                                form.addEventListener('submit', function(event) {
                                    if (form.checkValidity() === false) {
                                        event.preventDefault();
                                        event.stopPropagation();
                                    }
                                    form.classList.add('was-validated');
                                }, false);
                            });
                        }, false);
                    })();
                </script>
            </div>
        </div>
    </section>

    <!-- Basic features section-->

    <!-- Call to action section-->
    <!-- Your call to action section content goes here -->
    <section class="bg-gradient-primary-to-secondary" id="download">
        <div class="container px-5">
            <h2 class="text-center text-white font-alt mb-4">Start using our Services</h2>
            <div class="d-flex flex-column flex-lg-row align-items-center justify-content-center">
                <button class="btn btn-primary rounded-pill px-3 mb-2 mb-lg-0"><a class="nav-link" href="/logi.php">
                        <span class="d-flex align-items-center">
                            <i class="bi bi-box-arrow-in-left"></i>
                            <span class="small"> &nbsp;Login</span>
                        </span></a>
                </button>
                &nbsp;&nbsp;
                <button class="btn btn-primary rounded-pill px-3 mb-2 mb-lg-0">
                    <a class="nav-link" href="/register.php">
                        <span class="d-flex align-items-center">
                            <i class="bi bi-box-arrow-in-right"></i>
                            <span class="small"> &nbsp;Signup</span>
                        </span>
                    </a>
                </button>
            </div>
        </div>
    </section>
    <!-- App badge section-->

    <!-- Footer-->
    <footer class="bg-black text-center py-4">
        <div class="container text-white-50 small px-5 text-center">
            <div class="mb-2">
                <div>
                    &copy; Copyright <script>
                        document.write(new Date().getFullYear());
                    </script>.
                    DigitsHub, All Rights Reserved.
                </div>
            </div>
            <div>
                <a href="privacy.php">Privacy</a>
                <span class="mx-1">&middot;</span>
                <a href="terms.php">Terms</a>
            </div>
        </div>
    </footer>
    <!-- Bootstrap core JS-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Core theme JS-->
    <script src="/home/js/scripts.js"></script>
</body>

</html>