<?php
require_once __DIR__ . '/include/config.php'; // Adjust path as needed

function generateUsername($name, $conn) {
    $baseUsername = strtolower(preg_replace("/[^a-zA-Z0-9]/", "", $name));
    $username = $baseUsername;
    $counter = 1;

    // Ensure uniqueness
    while (true) {
        $stmt = $conn->prepare("SELECT id FROM user_data WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows == 0) {
            break;
        }

        $username = $baseUsername . $counter;
        $counter++;
    }

    return $username;
}

// Fetch users with empty or null usernames
$sql = "SELECT id, name FROM user_data WHERE username IS NULL OR username = ''";
$result = $conn->query($sql);

$updated = 0;
$skipped = 0;

while ($row = $result->fetch_assoc()) {
    $userId = $row['id'];
    $name = $row['name'];

    if (!empty($name)) {
        $newUsername = generateUsername($name, $conn);

        $stmt = $conn->prepare("UPDATE user_data SET username = ? WHERE id = ?");
        $stmt->bind_param("si", $newUsername, $userId);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            $updated++;
        }
    } else {
        $skipped++;
    }
}

echo "✅ Username update completed. Users updated: $updated. Users skipped (empty name): $skipped.";

$conn->close();
?>
