<?php
require_once __DIR__ . '/include/config.php';
if(isset($_SESSION['token'])){
	header('location: dashboard');
}

// Check if the remember me cookie exists
if (isset($_COOKIE['remember_me'])) {
    $remember_token = $_COOKIE['remember_me'];

    // Look up the remember token in the database
    $stmt = $conn->prepare('SELECT * FROM login_token WHERE token = ?');
	$stmt->bind_param("s", $remember_token);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    if ($result->num_rows > 0) {
        // Log the user in
        $_SESSION['token'] = $data['token'];

        // Redirect to the dashboard
        header('Location: dashboard.php');
        exit;
    }
}

if(isset($_GET['msg'])){
	$error_data=$_GET['msg'];
	if($error_data=="not_found"){
		$msg1="Account Not Found. Please <a style='text-decoration: underline;' href='register'>register</a> in website then login.";
		$button_msg='Register Now';
		$button_url="register";
	}else if($error_data=="block"){
		$msg1="Your Account Blocked By Admin Please Contact Our Support Team";
		$button_msg='Contact Now';
		$button_url=$site_data['support_url']; 
	}else if($error_data=="error"){
		$msg1="There was an error processing your request.";
	}else if($error_data=="reset-success"){
		$msg1="You have successfully changed your password.";
	}else{
		$msg1="You don’t have permission to access this page. Go Home!!";
		$button_msg='Back To Home';
		$button_url="index";  
	}
}
include_once __DIR__ . '/theam/' . THEME . '/index.php';

?>