import { toast } from 'https://cdn.skypack.dev/wc-toast';

// Bind Nice Select for all dropdowns
const options1 = { searchable: true, placeholder: 'Select Country' };
var op1 = NiceSelect.bind(document.getElementById("country-id"), options1);

const options2 = { searchable: true, placeholder: 'Select Service' };
var op2 = NiceSelect.bind(document.getElementById("service-id"), options2);

const options3 = { searchable: true, placeholder: 'Select Duration' };
var op3 = NiceSelect.bind(document.getElementById("duration-id"), options3);

$(document).ready(function () {
  // Initial state
  $('#services-container').addClass('hidden');
  $('#rental-duration-container').addClass('hidden');
  $('#pricing-information-view').html('');

  // When a country is selected
  $('#country-id').change(function () {
    const countryId = $(this).val();
    const token = $("#token").val();

    // Reset dependent fields
    $('#pricing-information-view').html('');
    $('#rental-duration-container').addClass('hidden');
    $("#duration-id").val(""); 
    op3.update();

    if (!countryId) {
      $('#services-container').addClass('hidden');
      $('#service-id').empty().append('<option value="">Select Service</option>');
      return;
    }

    // Show loader and clear services
    $("#service-id").empty().append('<option value="" selected disabled>Loading.....</option>');
    $("#services-loader").removeClass("hidden");
    $('#services-container').removeClass('hidden');

    $.ajax({
      type: "GET",
      url: "api/service/getRentalServices.php",
      data: { token, server: countryId },
      dataType: "json",
      success: function (data) {
        $("#service-id").empty().append('<option value="" selected disabled>Select Service</option>');
        data['service'].forEach(service => {
          const poolInfo = service['pool_id'] ? ` (Pool - ${service['pool_id']})` : '';
          const optionHTML = `<option value="${service['id']}${service['pool_id'] ? ',' + service['pool_id'] : ''}">${service['service_name']}${poolInfo}</option>`;
          $("#service-id").append(optionHTML);
        });
        $("#services-loader").addClass("hidden");
        op2.update();
      },
      error: function (e) {
        console.error("Service fetch failed", e);
        toast.error("Could not fetch services.");
        $("#services-loader").addClass("hidden");
      }
    });
  });

  // When a service is selected
  $("#service-id").change(function () {
    const selected = $(this).val();
    if (!selected) return;

    $('#pricing-information-view').html('');
    $('#rental-duration-container').removeClass('hidden');
    op3.update();
  });

  // When a duration is selected
  $("#duration-id").change(function () {
    const server = $("#country-id").val();
    const service = $("#service-id").val();
    const duration = $(this).val();
    const token = $("#token").val();

    if (!server || !service || !duration) return;

    const params = { token, server, service, duration };

    $.ajax({
      type: "GET",
      url: "api/service/getRentalServicePrice",
      data: params,
      dataType: "json",
      beforeSend: function () {
        $("#buy-numbers").attr("disabled", true);
        $("#service-price-loader").removeClass("hidden");
        $("#pricing-information-view").html('');
      },
      success: function (data) {
        if (data.status === "200") {
          $("#pricing-information-view").html(data.message);
          $("#buy-numbers").attr("disabled", false);
        } else {
          toast.error(data.message || "Failed to fetch price.");
        }
        $("#service-price-loader").addClass("hidden");
      },
      error: function (e) {
        console.error("Price fetch error", e);
        toast.error("Error retrieving price.");
        $("#service-price-loader").addClass("hidden");
      }
    });
  });

  // When "Rent Number" is clicked
  $("#buy-numbers").click(function () {
    const server = $("#country-id").val();
    const service = $("#service-id").val();
    const duration = $("#duration-id").val();
    const token = $("#token").val();

    if (!server) {
      toast.error('Please Select Country');
      return;
    }

    if (!service) {
      toast.error('Select Service');
      return;
    }

    if (!duration) {
      toast.error('Select Duration');
      return;
    }

    $(this).prop("disabled", true);
    $(this).html('<span class="animate-spin border-2 border-white border-l-transparent rounded-full w-4 h-4 inline-block align-middle mr-2"></span> Finding Number...');

    const params = { server, service, duration, token };

    $.ajax({
      type: "GET",
      url: "api/service/buyrentalnumber",
      data: params,
      success: function (data) {
        $("#buy-numbers").prop("disabled", false).html("<i class='fa fa-cart-plus mr-2'></i>Rent Number");

        const res = JSON.parse(data);
        if (res.status === "200") {
          toast.success(res.message);
          checkOrder(); // optional: implement this function as needed
        } else {
          toast.error(res.message || "Failed to rent number.");
        }
      },
      error: function (e) {
        console.error(e);
        toast.error("An error occurred.");
        $("#buy-numbers").prop("disabled", false).html("<i class='fa fa-cart-plus mr-2'></i>Rent Number");
      }
    });
  });
});
