<?php
require_once __DIR__ . '/include/config.php';

// Check if the remember me cookie exists
if (isset($_COOKIE['remember_me'])) {
    $remember_token = $_COOKIE['remember_me'];

    // Look up the remember token in the database
    // Look up the remember token in the database
    $stmt = $conn->prepare('SELECT * FROM login_token WHERE token = ?');
	$stmt->bind_param("s", $remember_token);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    if ($result->num_rows > 0) {
        // Log the user in
        $_SESSION['token'] = $data['token'];
    }
}

if (isset($_SESSION['token'])) {
    $userLoggedIn = true;
    $wallet = new radiumsahil();
    $userdata = $wallet->userdata();
} else {
    $userLoggedIn = false;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title> Buy Virtual Numbers - Tmpverify</title>
    <link rel="icon" type="home/image/x-icon" href="img/temi.jpg">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
    <!-- Bootstrap icons-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Newsreader:ital,wght@0,600;1,600&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,300;0,500;0,600;0,700;1,300;1,500;1,600;1,700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,400;1,400&amp;display=swap" rel="stylesheet">
    <!-- Core theme CSS (includes Bootstrap)-->
    <link href="Lmg/style.css?v=1" rel="stylesheet">
    <style>
        #typingText,
        #typingTex {
            font-size: 2.5rem;
            font-weight: bold;
            color: black;
            text-transform: uppercase;
            background: linear-gradient(90deg, black, #912027);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            display: inline;
        }

        .container1 {
            width: 1px;
            height: 1px;
            overflow: hidden;
        }

        .container1 img {
            width: 100%;
            height: auto;
        }

        .float {
            text-decoration: none;
            position: fixed;
            width: 60px;
            height: 60px;
            bottom: 70px;
            right: 40px;
            background-color: rgb(73 111 217);
            color: #FFF;
            border-radius: 50px;
            text-align: center;
            font-size: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
            z-index: 100;
        }

        .float:hover{
            color: #fff;
        }
    </style>
</head>

<body id="page-top">
    <!-- Navigation-->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top border-bottom" id="mainNav">
        <div class="container">
            <a class="navbar-brand me-4" href="#page-top">
                <img src="img/temi.jpg" alt="Logo Image" width="100" />
                <!--<span class="fs-6" style="color: #496fd9;">Tmpverify sms verify</span>-->
            </a>
            <div class="justify-content-lg-center order-2 collapse navbar-collapse" id="navbarResponsive">
                <ul class="navbar-nav my-3 my-lg-0">
                    <li class="nav-item me-2">
                        <a class="nav-link" href="#" data-section-target="masthead">Home</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="#" data-section-target="about-us">About Us</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="#" data-section-target="contact-us">Contact Us</a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="#" data-section-target="features">How to Use</a>
                    </li>
                </ul>

                <?php
                if(!$userLoggedIn){
                ?>
                <ul class="nav justify-content-lg-end d-lg-none">
                    <li class="nav-item">
                        <a class="nav-link" href="login">Login</a>
                    </li>
                    <li class="nav-item">
                        <a href="register" class="btn btn-danger text-white">
                            Sign Up
                        </a>
                    </li>
                </ul>
                <?php
                    }
                ?>
            </div>
            <div class="d-flex align-items-center order-1 order-lg-3">
                <?php
                    if($userLoggedIn){
                ?>
                <ul class="nav justify-content-lg-end mr-2">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-target="#profileDropdown" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="bi bi-person fs-4"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="profileDropdown">
                            <a class="dropdown-item" href="dashboard">Dashboard</a>
                            <a class="dropdown-item" href="recharge">Recharge</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="buy-number">Buy Number</a>
                        </div>
                    </li>
                </ul>
                <?php
                    }
                ?>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                    <i class="bi-list"></i>
                </button>
                <?php
                if(!$userLoggedIn){
                ?>
                <ul class="nav justify-content-lg-end d-none d-lg-flex">
                    <li class="nav-item">
                        <a class="nav-link" href="login">Login</a>
                    </li>
                    <li class="nav-item">
                        <a href="register" class="btn btn-danger text-white">
                            Sign Up
                        </a>
                    </li>
                </ul>
                <?php
                    }
                ?>
            </div>
        </div>
    </nav>

    <!-- Masthead CTA section-->
    <section id="masthead" class="masthead bg-danger bg-opacity-25">
        <div class="container my-5">
            <div class="row gx-0 gx-sm-5">
                <div class="col-lg-6">
                    <!-- Mashead text and app badges-->
                    <div class="mb-lg-0">
                        <h1 class="home-heading-text display-1 mb-5">
                            <p id="typingTex"></p>
                        </h1>
                        <p class="lead fs-6 text-muted">
                            "Buy Premium Quality OTP in Cheapest Price and stay safe from unwanted promotional sms and calls and also prevent your identity from fraudsters"
                        </p>
                        <div class="register-form-container position-relative">
                            &nbsp;
                            <form action="register" class="register-form d-flex flex-sm-row flex-column justify-content-between align-items-stretch align-items-sm-center mt-1 mb-3 px-3 py-3 bg-white rounded-4 shadow-lg">
                                <div class="form-group" style="width: 75%;">
                                    <label for="email" class="mb-2">Register Email Address</label>
                                    <input type="email" name="email" class="form-control" id="email" placeholder="name@example.com" required>
                                </div>
                                <div class="align-self-stretch align-self-sm-end">
                                    <button class="btn btn-danger text-white w-100 mt-2 mt-sm-0">Sign Up</button>
                                </div>
                            </form>
                        </div>
                        <div class="bottom-image-container position-relative">
                            <img class="dot-ornament" src="img/dot-ornament.png" alt="CTA Image" class="img-fluid" />
                            <img src="img/landing-photo-3.png" class="d-block ms-auto" alt="CTA Image" class="img-fluid" />
                            <div class="design-dot purple-dot"></div>
                        </div>
                    </div>
                </div>
                <div class="d-none d-lg-block col-lg-6 position-relative">
                    <div class="design-dot green-dot"></div>
                    <div class="h-100 w-100">
                        <img src="img/landing-png.png" alt="CTA Image" class="img-fluid mx-auto" style="max-width: 100%" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about-us" class="about-section">
        <div class="container">
            <div class="row gx-sm-5 gx-0 gy-2 gy-sm-0">
                <div class="col-lg-5">
                    <p><span class="text-danger font-bold">"Tmpverify sms verify"</span> gives you the opportunity to buy a virtual number for registration in popular services at the best price on the net. Previously, to register an additional account in a social network or messenger you had to buy a SIM-card or ask your husband/wife to share the phone (which is not always possible)..</p>
                    <p>First of all, it costs money to get a new SIM card. Secondly, it is a whole event - to come to the office, fill out a form with passport data...</p>
                    <p>On this site you can buy a virtual phone number for Telegram, Whatsapp, Viber, Instagram, Facebook, and any other popular platform from just NGN 2000.</p>
                </div>
                <div class="col-lg-2 align-self-center text-center">
                    <img src="img/temi.jpg" alt="logo" class="img-fluid" style="height: 120px;">
                </div>
                <div class="col-lg-5">
                    <p>The service is suitable for users who need one-time SMS verification of accounts in social networks, messengers, payment systems, dating sites and any other services that require SMS verification.</p>
                    <p>Get a virtual phone number in just a few minutes!</p>
                    <p>The entire process is automated and occurs in a user-friendly interface. There is no need to contact managers to connect the number. At the same time, support is always ready to help in case of anything.</p>
                    <p>So feel free to use it!</p>
                </div>
            </div>
        </div>
    </section>
    <!-- Customer service section-->
    <section id="contact-us" class="bg-danger bg-opacity-25">
        <div class="container">
            <div class="row gx-sm-5 gx-0">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="position-relative mx-auto">
                        <img src="img/customer-service-2.png" class="customer-service-img" />
                        <img src="img/customer-service-1.png" alt="#" class="d-block mx-auto" style="width: 60%">
                        <div class="start-chat-block bg-white shadow-lg rounded-5 p-1 d-flex align-items-center">
                            <div class="chat-icon fs-4 bg-success bg-opacity-75 text-white d-flex align-items-center justify-content-center">
                                <i class="bi-chat"></i>
                            </div>
                            <div class="px-3">
                                <p class="mb-1 text-muted fw-bold" style="font-size: 14px;">Start Chat</p>
                                <p class="mb-0 text-muted" style="font-size: 12px;">With Customer Care</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 d-flex flex-column justify-content-center">
                    <h2 class="display-5 mb-4 text-white">We provide 24X7 Customer Support</h2>
                    <p class="fs-6 text-white">Our Highly trained Customer support executives are always ready to solve your each and every problems and answer your every queries, Feel free to contact us anytime.</p>
                    <a href="#" class="align-self-start align-self-md-stretch btn btn-danger">Contact Us Today</a>
                </div>
            </div>
        </div>
    </section>
    <br> <br>

    <!-- How To section-->
    <section id="features">
        <div class="container">
            <div class="title">
                <h2 class="display-5 lh-1 mb-4 fw-semibold text-center">
                    How To Use
                </h2>
            </div>
            <div class="row">
                <div class="mx-auto col-lg-8 order-lg-1 mb-5 mb-lg-0">
                    <div class="container-fluid px-5">
                        <div class="row">
                            <div class="col-md-6 mb-5 mb-md-0">
                                <div class="p-3 text-center border rounded-4 border-danger">
                                    <i class="bi bi-basket-fill icon-feature text-gradient d-block mb-3"></i>
                                    <h3 class="font-alt">Select Services</h3>
                                    <p class="text-muted mb-0">Just select the service, for which you needed the number!</p>
                                </div>
                            </div>
                            <div class="col-md-6 mb-5 mb-md-0">

                                <div class="p-3 text-center border rounded-4 border-danger">
                                    <i class="bi bi-mailbox icon-feature text-gradient d-block mb-3"></i>
                                    <h3 class="font-alt">Place your Order</h3>
                                    <p class="text-muted mb-0">Place your order and we will provide you a number for signup!</p>
                                </div>
                            </div>
                        </div>
                        <div class="d-none d-md-block intersecting-dot"></div>
                        <div class="row">
                            <div class="col-md-6 mb-5 mb-md-0">
                                <!-- Feature item -->
                                <div class="p-3 text-center border rounded-4 border-danger">
                                    <i class="bi-phone icon-feature text-gradient d-block mb-3"></i>
                                    <h3 class="font-alt">Get the OTP</h3>
                                    <p class="text-muted mb-0">You will get the otp for that number and your order will get completed!</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <!-- Feature item -->
                                <div class="p-3 text-center border rounded-4 border-danger">
                                    <i class="bi bi-cash-coin icon-feature text-gradient d-block mb-3"></i>
                                    <h3 class="font-alt">Easy to Recharge</h3>
                                    <p class="text-muted mb-0">We provide easy payment methods for swift recharges/purchases!</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Your features section content goes here -->

    <!-- Contact Information -->
    <section id="contact-info" class="text-white text-center bg-danger bg-opacity-50">
        <div class="container px-5">
            <div class="row gx-5">
                <div class="col-md-6 mb-5 mb-md-0">
                    <div class="p-3">
                        <div class="icon-contact-container d-flex align-items-center justify-content-center text-white bg-dark bg-opacity-75 mb-2 mx-auto">
                            <i class="icon-contact bi-envelope"></i>
                        </div>
                        <h3>Email</h3>
                        <p>You can reach us @</p>
                        <a href="support@Tmpverifysmsverify.ng" class="text-white">support@tmpveify.ng</a>
                    </div>
                </div>
                <!-- <div class="col-md-4 mb-5 mb-md-0">
                    <div class="p-3">
                        <div class="icon-contact-container d-flex align-items-center text-white bg-dark bg-opacity-75 mb-2 mx-auto">
                            <i class="icon-contact bi-email p-4"></i>
                        </div>
                        <h3>Office</h3>
                        <p>Our friendly team is here to help</p>
                        <a href="Tmpverifygee@gmail.com" class="text-white">support@Tmpverifysmsverify.ng</a>
                    </div>
                </div> -->
                <div class="col-md-6 mb-5 mb-md-0">
                    <div class="p-3">
                    <!--    <div class="icon-contact-container d-flex align-items-center justify-content-center text-white bg-dark bg-opacity-75 mb-2 mx-auto">
                             class="icon-contact bi-phone-vibrate"></i> -->
                        </div>
                   <!--      <h3>Phone</h3>
                        <p>You can send a whatsapp message to:</p>
                        <a href="https://t.me/temilogs8" class="text-white">+234 906 8218 818</a> -->
                    </div>
                </div>
            </div>
        </div>
    </section> 

    <!-- Feedback Modal-->
    <!-- <section>
        <div class="container">
            <div class="title text-center">
                <h2 class="display-5 lh-1 mb-4 fw-semibold">
                    Have any Questions?
                </h2>
                <p class="fs-6">Please Fill the form below if you have any questions..</p>
            </div>
            <div class="p-4">
                <form id="contactForm" class="needs-validation" novalidate>
                    <div class="form-floating mb-3">
                        <input class="form-control" id="name" type="text" placeholder="Enter your name..." required />
                        <label for="name">Full name</label>
                        <div class="invalid-feedback">A full name is required.</div>
                    </div>
                    <div class="form-floating mb-3">
                        <input class="form-control" id="email" type="email" placeholder="name@example.com" required />
                        <label for="email">Email address</label>
                        <div class="invalid-feedback">Email is not valid.</div>
                    </div>
                    <div class="form-floating mb-3">
                        <input class="form-control" id="phone" type="tel" placeholder="(123) 456-7890" />
                        <label for="phone">Phone number</label>
                    </div>
                    <div class="form-floating mb-3">
                        <textarea class="form-control" id="message" type="text" placeholder="Enter your message here..." style="height: 10rem" required ></textarea>
                        <label for="message">Message</label>
                        <div class="invalid-feedback" data-sb-feedback="message:required">A message is required.</div>
                    </div>
                    <div class="d-none" id="submitSuccessMessage">
                        <div class="text-center mb-3">
                            <div class="fw-bolder">Form submission successful!</div>
                        </div>
                    </div>
                    <div class="d-grid">
                        <button class="btn btn-danger rounded-pill btn-lg" id="submitButton" type="submit">Submit</button>
                    </div>
                </form>
                <script>
                    // Example starter JavaScript for disabling form submissions if there are invalid fields
                    (function() {
                        'use strict';
                        window.addEventListener('load', function() {
                            // Fetch all the forms we want to apply custom Bootstrap validation styles to
                            var forms = document.getElementsByClassName('needs-validation');
                            // Loop over them and prevent submission
                            var validation = Array.prototype.filter.call(forms, function(form) {
                                form.addEventListener('submit', function(event) {
                                if (form.checkValidity() === false) {
                                    event.preventDefault();
                                    event.stopPropagation();
                                }
                                form.classList.add('was-validated');
                                }, false);
                            });
                        }, false);
                    })();
                </script>
            </div>
        </div>
    </section>  -->

    <!-- Basic features section-->

    <!-- Call to action section-->
    <!-- Your call to action section content goes here -->
    <section class="bg-gradient-danger-to-secondary" id="download">
        <div class="container px-5">
            <h2 class="text-center text-white font-alt mb-4">Start using our Services</h2>
            <div class="d-flex flex-column flex-lg-row align-items-center justify-content-center">
                <button class="btn btn-danger px-3 mb-2 mb-lg-0"><a class="nav-link" href="./login">
                        <span class="d-flex align-items-center">
                            <i class="bi bi-box-arrow-in-left"></i>
                            <span class="small"> &nbsp;Login</span>
                        </span></a>
                </button>
                &nbsp;&nbsp;
                <button class="btn btn-danger px-3 mb-2 mb-lg-0">
                    <a class="nav-link" href="./register">
                        <span class="d-flex align-items-center">
                            <i class="bi bi-box-arrow-in-right"></i>
                            <span class="small"> &nbsp;Register</span>
                        </span>
                    </a>
                </button>
            </div>
        </div>
    </section>
    <!-- App badge section-->

    <!-- Footer-->
    <footer class="bg-dark py-4">
        <div class="container-fluid text-white px-5">
            <div class="row">
                <div class="col-md-6 mb-2 mb-md-0">
                    <p class="mb-0 text-center text-md-start">&copy; Copyright <script>
                            document.write(new Date().getFullYear());
                        </script>. Tmpverify SMS Verify, All Rights Reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <a href="privacy.php">Privacy</a>
                    <span class="mx-1">&middot;</span>
                    <a href="terms.php">Terms</a>
                </div>
            </div>
        </div>
    </footer>
    
    <div class="floating_btn">
        <a target="_blank" href="#">
          <div class="contact_icon">
            <i class="fa fa-whatsapp my-float"></i>
          </div>
        </a>
        <p class="text_icon">Join channel</p>
    </div>
    <style>
      a{
      text-decoration:none;
    }
    .floating_btn {
      position: fixed;
      bottom: 20px;
      right: 20px;
      width: 100px;
      height: 100px;
      display: flex;
      flex-direction: column;
      align-items:center;
      justify-content:center;
      z-index: 1000;
    }
    
    @keyframes pulsing {
      to {
        box-shadow: 0 0 0 30px rgba(232, 76, 61, 0);
      }
    }
    
    .contact_icon {
      background-color: #42db87;
      color: #fff;
      width: 60px;
      height: 60px;
      font-size:30px;
      border-radius: 50px;
      text-align: center;
      box-shadow: 2px 2px 3px #999;
      display: flex;
      align-items: center;
      justify-content: center;
      transform: translatey(0px);
      animation: pulse 1.5s infinite;
      box-shadow: 0 0 0 0 #42db87;
      -webkit-animation: pulsing 1.25s infinite cubic-bezier(0.66, 0, 0, 1);
      -moz-animation: pulsing 1.25s infinite cubic-bezier(0.66, 0, 0, 1);
      -ms-animation: pulsing 1.25s infinite cubic-bezier(0.66, 0, 0, 1);
      animation: pulsing 1.25s infinite cubic-bezier(0.66, 0, 0, 1);
      font-weight: normal;
      font-family: sans-serif;
      text-decoration: none !important;
      transition: all 300ms ease-in-out;
    }
    
    .text_icon {
      margin-top: 8px;
      font-size: 13px;
      background-color: white;
      padding: 0.2rem 0.5rem;
      border-radius: 10px;
      box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
    }
  </style>

    <!-- Bootstrap core JS-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- JQUERY -->
     <script src="./js/jquery/jquery-3.6.min.js"></script>
     
    <!-- Typing effect JS-->
    <script>
        //_______________Alphabet Smooth Scroll
        $("[data-section-target").on("click", function () {
            $("html, body").animate(
            {
                scrollTop: $("#" + $(this).data("section-target")).offset().top,
            },
            0
            );
            return false;
        });

        const texts = ["Secure Online SMS for Safe Registrations", "Protect Your Data with Online SMS"];
        // const texts = ["Welcome to Tmpverify SMS Verify", "At Tmpverify sms verify, We provide virtual numbers and OTP to protect your identity and privacy"];
        let index = 0;

        function typeText(text, index, elementId) {
            const typingSpeed = 100; // Adjust typing speed (milliseconds per character)
            const element = document.getElementById(elementId);
            let i = 0;

            function type() {
                if (i < text.length) {
                    element.textContent += text.charAt(i);
                    i++;
                    setTimeout(type, typingSpeed);
                } else {
                    // Wait for 1 second before typing the next text
                    setTimeout(() => {
                        // Clear the text and type the next one
                        element.textContent = "";
                        index = (index + 1) % texts.length;
                        typeText(texts[index], index, elementId);
                    }, 1000);
                }
            }

            type();
        }

        // Start typing for both elements
        typeText(texts[index], index, "typingTex");
    </script>
</body>

</html>