<!doctype html>
<html lang="en" dir="ltr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title> Google Register - <?php echo $web_name; ?></title>
</head>

<body>
    <wc-toast id="tt" position="top-right"> </wc-toast>

    <?php
    require_once __DIR__ . "/include/config.php";

    if (isset($_SESSION['token'])) {
        header('location: index');
    }

    require "vendor/autoload.php";

    function generateRandomString($length = 10)
    {
        $characters =
            "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $random_string = "";

        for ($i = 0; $i < $length; $i++) {
            $random_string .= $characters[rand(0, strlen($characters) - 1)];
        }

        return $random_string;
    }

    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $deviceString = "";
    $current_time_in_ist = date('Y-m-d H:i:s');
    if (preg_match('/iPhone|iPad|iPod/i', $user_agent)) {
        $deviceString = "Device: Apple iOS";
    } elseif (preg_match('/Android/i', $user_agent)) {
        $deviceString = "Device: Android";
    } elseif (preg_match('/Windows Phone/i', $user_agent)) {
        $deviceString = "Device: Windows Phone";
    } elseif (preg_match('/Macintosh|Mac OS X/i', $user_agent)) {
        $deviceString = "Device: Macintosh (Mac)";
    } elseif (preg_match('/Windows/i', $user_agent)) {
        $deviceString = "Device: Windows";
    } elseif (preg_match('/Linux/i', $user_agent)) {
        $deviceString = "Device: Linux";
    } else {
        $deviceString = "Device: Unknown";
    }

    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $browserData = "";

    // Use a regular expression to extract browser and version
    if (preg_match('/(MSIE|Edge|Firefox|Chrome|Safari|Opera)[\/\s](\d+\.\d+)/i', $user_agent, $matches)) {
        $browser = $matches[1]; // Browser name
        $version = $matches[2]; // Browser version
        $browserData = "Browser: " . $browser . " " . $version;
    } else {
        $browserData = "Browser information not found.";
    }

    function createUser($conn, $name, $username, $email, $password, $type, $img_url, $status)
    {
        $date = date("Y-m-d H:i:s");
        $email_verified = "1";
        $sql = $conn->prepare("INSERT INTO user_data(name, username, email, password, type, email_verified, register_date, image_url, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $sql->bind_param("sssssissi", $name, $username, $email, $password, $type, $email_verified, $date, $img_url, $status);
        $sql->execute();
    }

    function createWallet($conn, $user_id, $balance, $total_recharge, $total_otp)
    {
        $sql = $conn->prepare("INSERT INTO user_wallet(user_id, balance, total_recharge, total_otp) VALUES (?, ?, ?, ?)");
        $sql->bind_param("siii", $user_id, $balance, $total_recharge, $total_otp);
        $sql->execute();
    }

    $facebook_oauth_app_id = $site_data["facebook_client_id"];
    $facebook_oauth_app_secret = $site_data["facebook_client_secret"];
    // $facebook_oauth_redirect_uri = $site_data['web_url'] . '/facebook-register';
    $facebook_oauth_redirect_uri = WEBSITE_URL . '/facebook-register.php';
    $facebook_oauth_version = 'v18.0';

    if (isset($_GET["code"])) {
        $params = [
            'client_id' => $facebook_oauth_app_id,
            'client_secret' => $facebook_oauth_app_secret,
            'redirect_uri' => $facebook_oauth_redirect_uri,
            'code' => $_GET['code']
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/oauth/access_token');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($response, true);

        if (isset($response['access_token']) && !empty($response['access_token'])) {
            // Token is valid; let's fetch the email
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/' . $facebook_oauth_version . '/me?fields=name,email,picture');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $response['access_token']]);
            $response = curl_exec($ch);
            curl_close($ch);
            $profile = json_decode($response, true);


            if (isset($profile['email']) || isset($profile['name'])) {
                $name = mysqli_real_escape_string($conn, $profile['name']);
                $email = mysqli_real_escape_string($conn, $profile['email']);
                // $username = generateRandomString();
                // $password = md5($userInfo->getId() . '@tg');

                $sql = $conn->prepare("SELECT * FROM user_data WHERE email=?");
                $sql->bind_param("s", $email);
                $sql->execute();
                $result = $sql->get_result();

                if ($result->num_rows == 0) {
                    $type = "user";
                    $img_url = $profile['picture']['data']['url'];
                    // $img_url = "";
                    $status = 1;

                    createUser($conn, $name, '', $email, '', $type, $img_url, $status);

                    $inserted_id = $conn->insert_id;
                    $balance = 0;
                    $total_recharge = 0;
                    $total_otp = 0;

                    createWallet($conn, $inserted_id, $balance, $total_recharge, $total_otp);
                    $user_id = $inserted_id;
                    $token = generateRandomString();
                    // Setting remember me token to persist logging user in
                    setcookie('remember_me', $token, time() + (86400 * 30), "/");
                    $user_ip = $_SERVER['REMOTE_ADDR'];
                    $_SESSION['token'] = $token;
                    if ($data['type'] == "admin") {
                        $_SESSION['admin'] = $token;
                    }
                    $sql22 = mysqli_query($conn, "SELECT * FROM login_token WHERE user_id='" . $user_id . "'");
                    if (mysqli_num_rows($sql22) == 0) {
                        $sql2 = $conn->query("INSERT INTO login_token(user_id, token, create_date, device, browser, ip, status) VALUES ('" . $user_id . "','" . $token . "','" . $current_time_in_ist . "','" . $deviceString . "','" . $browserData . "','" . $user_ip . "','1')");
                    } else {
                        $sql23 = $conn->query("UPDATE login_token SET token='" . $token . "' WHERE user_id='" . $user_id . "'");
                    }
                    header('Location: dashboard');
                    exit();
                } else {
                    header("Location: register?msg=exists");
                    exit();
                }
            } else {
                header("Location: /");
                exit();
            }
        } else {
            header("Location: register?msg=error");
        }
    } else {
        header("Location: register?msg=error");
    }

    // Define params and redirect to Facebook OAuth page
    $params = [
        'client_id' => $facebook_oauth_app_id,
        'redirect_uri' => $facebook_oauth_redirect_uri,
        'response_type' => 'code',
        'scope' => 'email'
    ];
    header('Location: https://www.facebook.com/dialog/oauth?' . http_build_query($params));
    exit;
    ?>
</body>

</html>