<?php
require_once __DIR__ . '/../../include/config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => false, 'message' => 'Method Not Allowed']);
    exit;
}

$inputData = file_get_contents('php://input');
if (!$inputData) {
    http_response_code(400);
    echo json_encode(['status' => false, 'message' => 'No input data']);
    exit;
}

$webhookData = json_decode($inputData, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['status' => false, 'message' => 'Invalid JSON']);
    exit;
}

$amount = $webhookData['amount'] ?? null;
$email = $webhookData['email'] ?? null;
$order_id = $webhookData['order_id'] ?? null;

if (!$amount || !$email || !$order_id) {
    http_response_code(400);
    echo json_encode(['status' => false, 'message' => 'Missing required fields']);
    exit;
}

// Sanitize inputs
$email = $conn->real_escape_string($email);
$order_id = $conn->real_escape_string($order_id);
$amount = floatval($amount);

// Check if it's a DIRECTRESOLVE transaction
$isDirectResolve = strpos($order_id, 'DIRECTRESOLVE') !== false;

// Find user by email
$user_query = $conn->query("SELECT * FROM user_data WHERE email='$email' LIMIT 1");
if (!$user_query || $user_query->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => false, 'message' => 'User not found']);
    exit;
}
$user = $user_query->fetch_assoc();
$user_id = $user['id'];

// Check if transaction exists
$checkTxn = $conn->query("SELECT * FROM user_transaction WHERE txn_id='$order_id' LIMIT 1");
if (!$checkTxn || $checkTxn->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => false, 'message' => 'Transaction not found']);
    exit;
}
$transaction = $checkTxn->fetch_assoc();

if ($transaction['status'] == '1') {
    http_response_code(200);
    echo json_encode(['status' => false, 'message' => 'Transaction already processed']);
    exit;
}

// Prepare current timestamp
$current_time_in_ist = date('Y-m-d H:i:s');

// DIRECTRESOLVE: skip verification, credit immediately
if ($isDirectResolve) {
    $verified_amount = $amount;

    // Update transaction
    $conn->query("UPDATE user_transaction 
                  SET amount='$verified_amount', status='1', date='$current_time_in_ist' 
                  WHERE txn_id='$order_id'");

    // Update user wallet
    $wallet = $conn->query("SELECT * FROM user_wallet WHERE user_id='$user_id' LIMIT 1")->fetch_assoc();
    $new_balance = $wallet['balance'] + $verified_amount;
    $new_total_recharge = $wallet['total_recharge'] + $verified_amount;

    $conn->query("UPDATE user_wallet 
                  SET balance='$new_balance', total_recharge='$new_total_recharge' 
                  WHERE user_id='$user_id'");

    // Referral bonus (same logic reused)
    processReferralBonus($user_id, $verified_amount, $conn, $current_time_in_ist);

    echo json_encode(['status' => true, 'message' => 'DIRECTRESOLVE processed successfully']);
    exit;
}

// Normal verification flow via SprintPay API
$verify_url = "https://web.sprintpay.online/api/verify-transaction?trans_id=" . urlencode($order_id);
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $verify_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_status !== 200 || !$response) {
    http_response_code(500);
    echo json_encode(['status' => false, 'message' => 'Failed to verify transaction status']);
    exit;
}

$verify_data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE || !isset($verify_data['status'], $verify_data['message'], $verify_data['amount'])) {
    http_response_code(500);
    echo json_encode(['status' => false, 'message' => 'Invalid verification response']);
    exit;
}

if ($verify_data['status'] !== true || !in_array(strtolower($verify_data['message']), ['success', 'completed', 'paid'])) {
    http_response_code(400);
    echo json_encode(['status' => false, 'message' => 'Transaction not successful: ' . $verify_data['message']]);
    exit;
}

$verified_amount = floatval($verify_data['amount']);

// Update transaction
$conn->query("UPDATE user_transaction 
              SET amount='$verified_amount', status='1', date='$current_time_in_ist' 
              WHERE txn_id='$order_id'");

// Update user wallet
$wallet = $conn->query("SELECT * FROM user_wallet WHERE user_id='$user_id' LIMIT 1")->fetch_assoc();
$new_balance = $wallet['balance'] + $verified_amount;
$new_total_recharge = $wallet['total_recharge'] + $verified_amount;

$conn->query("UPDATE user_wallet 
              SET balance='$new_balance', total_recharge='$new_total_recharge' 
              WHERE user_id='$user_id'");

// Referral bonus
processReferralBonus($user_id, $verified_amount, $conn, $current_time_in_ist);

http_response_code(200);
echo json_encode(['status' => true, 'message' => 'Webhook processed successfully']);
exit;

// Helper function for referral bonus
function processReferralBonus($user_id, $verified_amount, $conn, $timestamp) {
    if ($verified_amount < 1000) return;

    $refer_query = $conn->query("SELECT * FROM refer_data WHERE user_id='$user_id' LIMIT 1");
    $refer_data = $refer_query ? $refer_query->fetch_assoc() : null;

    if ($refer_data && !empty($refer_data['refer_by'])) {
        $referrer_code = $conn->real_escape_string($refer_data['refer_by']);
        $sql510 = $conn->query("SELECT * FROM refer_data WHERE own_code='$referrer_code' LIMIT 1");
        $refer_data1 = $sql510 ? $sql510->fetch_assoc() : null;

        if ($refer_data1) {
            $add_refer_bal = 100;
            $total_add_refer = $refer_data1['balance'] + $add_refer_bal;
            $total_earn_refer = $refer_data1['total_earn'] + $add_refer_bal;

            $conn->query("UPDATE refer_data 
                          SET balance='$total_add_refer', total_earn='$total_earn_refer' 
                          WHERE own_code='$referrer_code'");

            // Credit referrer's wallet
            $refer_user_id = $refer_data1['user_id'];
            $refer_wallet_res = $conn->query("SELECT * FROM user_wallet WHERE user_id='$refer_user_id' LIMIT 1");
            $refer_wallet_data = $refer_wallet_res->fetch_assoc();

            $refer_new_balance = $refer_wallet_data['balance'] + $add_refer_bal;
            $refer_new_total_recharge = $refer_wallet_data['total_recharge'] + $add_refer_bal;

            $conn->query("UPDATE user_wallet 
                          SET balance='$refer_new_balance', total_recharge='$refer_new_total_recharge' 
                          WHERE user_id='$refer_user_id'");

            $conn->query("INSERT INTO refer_history (user_id, type, date, amount, status) 
                          VALUES ('$refer_user_id', 'Referral Earning via SprintPay', '$timestamp', '$add_refer_bal', '1')");
        }
    }
}
