<?php
require_once __DIR__ . '/../../include/config.php'; // Adjust if needed
header('Content-Type: application/json');

// Function to generate a unique username
function generateUsername($name, $conn) {
    $baseUsername = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $name));
    $username = $baseUsername;
    $counter = 1;

    while (true) {
        $stmt = $conn->prepare("SELECT id FROM user_data WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows === 0) {
            break;
        }

        $username = $baseUsername . $counter;
        $counter++;
    }

    return $username;
}

// Validate input
if (!isset($_POST['email']) || empty($_POST['email'])) {
    echo json_encode([
        'status' => false,
        'message' => 'Email is required.'
    ]);
    exit;
}

$email = mysqli_real_escape_string($conn, $_POST['email']);

$sql = $conn->prepare("SELECT id, name, username FROM user_data WHERE email = ?");
$sql->bind_param("s", $email);
$sql->execute();
$result = $sql->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        'status' => false,
        'message' => 'No user found, please check email and try again'
    ]);
    exit;
}

$user = $result->fetch_assoc();

if (empty($user['username'])) {
    $newUsername = generateUsername($user['name'], $conn);
    $updateStmt = $conn->prepare("UPDATE user_data SET username = ? WHERE id = ?");
    $updateStmt->bind_param("si", $newUsername, $user['id']);
    $updateStmt->execute();

    $user['username'] = $newUsername;
}

echo json_encode([
    'status' => true,
    'user' => $user['username']
]);

$conn->close();
?>
