<?php
require_once __DIR__ . '/../../include/config.php';
header('Content-Type: application/json');


// Validate input
if (!isset($_POST['email']) || empty($_POST['email']) || !isset($_POST['amount']) || empty($_POST['amount'])) {
    echo json_encode([
        "status" => "500",
        "message" => "Required fields not passed"
    ]);
    exit;
}

$email = mysqli_real_escape_string($conn, $_POST['email']);
$amount = mysqli_real_escape_string($conn, $_POST['amount']);
$amount_clean = $amount;
$reference = uniqid("sprint_");

$current_time_in_ist = date('Y-m-d H:i:s');

// Validate session token
$find_token = new radiumsahil();
$check_token = $find_token->check_token($_SESSION['token']);

if ($check_token === false) {
    echo json_encode([
        "status" => "500",
        "message" => "Token Expired. Please Logout And Login Again"
    ]);
    exit;
}

$user_id = $check_token;

// Insert transaction into DB (pending state = 2)
$sqladd2 = "INSERT INTO user_transaction (user_id, amount, date, type, txn_id, status) 
            VALUES ('$user_id', '$amount_clean', '$current_time_in_ist', 'SprintPay', '$reference', '2')";
mysqli_query($conn, $sqladd2);

// Build SprintPay redirect URL
$api_key = "9876544567898765456";
$redirect_url = "https://web.sprintpay.online/pay?amount={$amount}&key={$api_key}&ref={$reference}&email={$email}";

// Return response
echo json_encode([
    'status' => "200",
    'redirect' => $redirect_url
]);
?>
