<?php
session_start();
require_once __DIR__ . '/../../include/config.php';

// Check required GET params
if (!isset($_GET['trans_id'], $_GET['amount'])) {
    $_SESSION['error_message'] = "Invalid request parameters.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

$ref = $conn->real_escape_string($_GET['trans_id']);
$amount_param = floatval($_GET['amount']);

// Call SprintPay verify transaction API
$verify_url = "https://web.sprintpay.online/api/verify-transaction?trans_id=" . urlencode($ref);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $verify_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$curl_error = curl_error($ch);
curl_close($ch);

if ($curl_error) {
    $_SESSION['error_message'] = "Error verifying transaction: " . $curl_error;
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

$verify_response = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    $_SESSION['error_message'] = "Invalid response from verification API.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

// Check if verification succeeded and status is successful
if (!isset($verify_response['status']) || $verify_response['status'] !== true) {
    $_SESSION['error_message'] = "Transaction verification failed.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

$status_message = strtolower($verify_response['message'] ?? '');

if ($status_message !== 'success' && $status_message !== 'completed' && $status_message !== 'paid') {
    $_SESSION['error_message'] = "Your payment was unsuccessful please try again.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

$verified_amount = floatval($verify_response['amount'] ?? 0);
if ($verified_amount <= 0) {
    $_SESSION['error_message'] = "Invalid amount received from verification.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

// Now proceed to update DB only if transaction exists
$checkTxn = $conn->query("SELECT * FROM user_transaction WHERE txn_id='$ref' LIMIT 1");
if (!$checkTxn || $checkTxn->num_rows === 0) {
    $_SESSION['error_message'] = "Transaction not found.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

$transaction = $checkTxn->fetch_assoc();
$user_id = $transaction['user_id'];

// If already successful, redirect with success message (optional)
if ($transaction['status'] == '1') {
    $_SESSION['success_message'] = "Transaction already processed successfully.";
    header("Location: " . WEBSITE_URL . "/dashboard");
    exit;
}

// Update transaction to success with verified amount
$current_time_in_ist = date('Y-m-d H:i:s');
$conn->query("UPDATE user_transaction SET amount='$verified_amount', status='1', date='$current_time_in_ist' WHERE txn_id='$ref'");

// Update user wallet
$user_wallet_res = $conn->query("SELECT * FROM user_wallet WHERE user_id='$user_id' LIMIT 1");
$user_wallet_data = $user_wallet_res->fetch_assoc();

$new_balance = $user_wallet_data['balance'] + $verified_amount;
$new_total_recharge = $user_wallet_data['total_recharge'] + $verified_amount;

$conn->query("UPDATE user_wallet SET balance='$new_balance', total_recharge='$new_total_recharge' WHERE user_id='$user_id'");

// Referral Bonus - Only if amount >= 1000
$refer_query = $conn->query("SELECT * FROM refer_data WHERE user_id='$user_id' LIMIT 1");
$refer_data = $refer_query ? $refer_query->fetch_assoc() : null;

if ($refer_data && !empty($refer_data['refer_by']) && $verified_amount >= 1000) {
    $referrer_code = $conn->real_escape_string($refer_data['refer_by']);
    $sql510 = $conn->query("SELECT * FROM refer_data WHERE own_code='$referrer_code' LIMIT 1");
    $refer_data1 = $sql510 ? $sql510->fetch_assoc() : null;

    if ($refer_data1) {
        $add_refer_bal = 100;
        $total_add_refer = $refer_data1['balance'] + $add_refer_bal;
        $total_earn_refer = $refer_data1['total_earn'] + $add_refer_bal;

        $conn->query("UPDATE refer_data SET balance='$total_add_refer', total_earn='$total_earn_refer' WHERE own_code='$referrer_code'");

        // Credit referred user's wallet
        $refer_user_id = $refer_data1['user_id'];
        $refer_wallet_res = $conn->query("SELECT * FROM user_wallet WHERE user_id='$refer_user_id' LIMIT 1");
        $refer_wallet_data = $refer_wallet_res->fetch_assoc();

        $refer_new_balance = $refer_wallet_data['balance'] + $add_refer_bal;
        $refer_new_total_recharge = $refer_wallet_data['total_recharge'] + $add_refer_bal;

        $conn->query("UPDATE user_wallet SET balance='$refer_new_balance', total_recharge='$refer_new_total_recharge' WHERE user_id='$refer_user_id'");

        // Add Referral History
        $conn->query("INSERT INTO refer_history (user_id, type, date, amount, status) 
                      VALUES ('$refer_user_id', 'Referral Earning via SprintPay', '$current_time_in_ist', '$add_refer_bal', '1')");
    }
}

// Set success message and redirect
$_SESSION['success_message'] = "Payment processed successfully.";
header("Location: " . WEBSITE_URL . "/dashboard");
exit;
