<?php
require_once __DIR__ . '/../../include/config.php';

if (!isset($_GET['server']) || $_GET['server'] == "") {
    echo "Invalid Server";
} elseif (!isset($_GET['service']) || $_GET['service'] == "") {
    echo "Invalid Service";
} elseif ((!isset($_GET['token']) || $_GET['token'] == "")) {
    echo "Invalid Token";
} else {
    $token = mysqli_real_escape_string($conn, $_GET['token']);
    $find_token = new radiumsahil();
    $check_token = $find_token->check_token($token);
    $find_token->closeConnection();
    if ($check_token === false) {
        echo 'Token Expired Please Logout And Login Again';
    } else {
        $server = $_GET['server'];
        $service = $_GET['service'];
        $sql = "SELECT * FROM otp_server WHERE id = " . $server . "";
        $result = mysqli_query($conn, $sql);
        $data = mysqli_fetch_assoc($result);

        if ($data) { // Check if the query was successful
            $sql4 = mysqli_query($conn, "SELECT * FROM api_detail WHERE id='" . $data['api_id'] . "'");
            $api_data = mysqli_fetch_assoc($sql4);
            $api_key = $api_data['api_key'];
            $api_url = $api_data['api_url'];
            $api_name = $api_data['api_name'];
            $api_rate = (float) $api_data['api_rate'];
            $api_percentage_increase = (float) $api_data['api_percentage_increase'];
            $server_code = $data['server_code'];

            if (strpos($service, ',') !== false) {
                $service_split = explode(',', trim($service));
                $sql5 = mysqli_query($conn, "SELECT * FROM service WHERE service_id='" . $service_split[0] . "' AND server_id='" . $server . "' AND pool_id='" . $service_split[1] . "' ");
            }else{
                $sql5 = mysqli_query($conn, "SELECT * FROM service WHERE service_id='" . $service . "' AND server_id='" . $server . "'");
            }
            $service_data = mysqli_fetch_assoc($sql5);
            $service_pool = $service_data['pool_id'] ?? "";
            $url = "";

            switch ($api_name) {
                case "sms-pool":
                    // sms-pool
                    $url = "{$api_url}/request/price?key={$api_key}&service={$service_data['service_id']}&country={$server_code}&pool={$service_pool}";
                    break;
                case "Gogetsms":
                    $url = "{$api_url}/stubs/handler_api.php?api_key={$api_key}&action=getPrices&country={$server_code}";
                // default:
                //     $url = "{$api_url}/stubs/handler_api.php?api_key={$api_key}&action=getNumber&service={$service}&country={$server_code}";
            }

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

            $response = curl_exec($ch);

            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $header = substr($response, 0, $header_size);
            $body = substr($response, $header_size);

            curl_close($ch);

            if ($response === false) {
                // echo'{"status":"500","message":"cURL error' . curl_error($ch) . '"}';
                echo '{"status":"500","message":"Sorry we\'re experiencing troubles getting service price. Please try again later."}';
                exit();
            } else {
                $response = (array) json_decode($response);
                
                $service_price_calc = 0;

                if(!isset($response[$server_code])){
                    echo'{"status":"500","message":"No price was found for this pool."}';
                    exit();
                }
                
                if(isset($response[$server_code]->$service->cost)){
                    $service_price_calc = $response[$server_code]->$service->cost;
                }
                
                // Do conversion 
                // $service_price_in_dollars_with_interest = round((($api_percentage_increase/100) * $service_price_calc) + $service_price_calc, 2);
                
                // $service_price_in_naira = $api_rate * $service_price_in_dollars_with_interest;
                $service_price_in_naira = ($api_rate * $service_price_calc) + 1000;
        
                // Update database prices
                if($service_pool !== ""){
                    $sql5 = mysqli_query($conn, "UPDATE service SET service_price='" . $service_price_in_naira . "' WHERE service_id='" . $service_data['service_id'] . "' AND pool_id='" . $service_pool . "' AND id='" . $service_data['id'] . "'");
                }else{
                    $sql5 = mysqli_query($conn, "UPDATE service SET service_price='" . $service_price_in_naira . "' WHERE service_id='" . $service_data['service_id'] . "' AND id='" . $service_data['id'] . "'");
                }
                $service_string = $service_pool !== ""? $service_data['service_name'] . " (Pool - " . $service_data['pool_id'] . ")" :  $service_data['service_name'];
                
                // echo '{"status":"200","message":"The price of ' . $service_string . ' is ₦' . number_format($service_price_in_naira,2) . ' and with success rate of '.  $response['success_rate'].'%"}';
                echo '{"status":"200","message":"The price of ' . $service_string . ' is ₦' . number_format($service_price_in_naira,2) . '"}';
            }
        }
    }
}
