<?php
require_once __DIR__ . '/../../include/config.php';

if (!isset($_GET['server']) || $_GET['server'] == "") {
    echo "Invalid Server";
} elseif (!isset($_GET['service']) || $_GET['service'] == "") {
    echo "Invalid Service";
} elseif ((!isset($_GET['token']) || $_GET['token'] == "")) {
    echo "Invalid Token";
} else {
    $token = mysqli_real_escape_string($conn, $_GET['token']);
    $find_token = new radiumsahil();
    $check_token = $find_token->check_token($token);
    $find_token->closeConnection();
    if ($check_token === false) {
        echo 'Token Expired Please Logout And Login Again';
    } else {
        $server = $_GET['server'];
        $service = $_GET['service'];
        $sql = "SELECT * FROM otp_server WHERE id = " . $server . "";
        $result = mysqli_query($conn, $sql);
        $data = mysqli_fetch_assoc($result);

        if ($data) { // Check if the query was successful
            $sql4 = mysqli_query($conn, "SELECT * FROM api_detail WHERE id='" . $data['api_id'] . "'");
            $api_data = mysqli_fetch_assoc($sql4);
            $api_key = $api_data['api_key'];
            $api_url = $api_data['api_url'];
            $api_name = $api_data['api_name'];
            $server_code = $data['server_code'];

            $sql5 = mysqli_query($conn, "SELECT * FROM platforms_data WHERE platform_id='" . $service . "'");
            $platform_data = mysqli_fetch_assoc($sql5);
            $url = "";

            switch ($api_name) {
                case "sms-man":
                    // sms-man sample rest-api: https://api.sms-man.com/control/get-number?token=$token&country_id=$country_id&application_id=$application_id
                    $url = "{$api_url}/control/limits?token={$api_key}&application_id={$service}&country_id={$server_code}";
                    break;
                default:
                    $url = "{$api_url}/stubs/handler_api.php?api_key={$api_key}&action=getNumber&service={$service}&country={$server_code}";
            }

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

            $response = curl_exec($ch);

            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $header = substr($response, 0, $header_size);
            $body = substr($response, $header_size);

            curl_close($ch);

            if ($result === false) {
                // echo'{"status":"500","message":"cURL error' . curl_error($ch) . '"}';
                echo '{"status":"500","message":"Sorry we\'re experiencing troubles getting number counts. Please check back later."}';
                exit();
            } else {
                $response = $api_name !== "sms-man" ? explode(':', $result) : (array) json_decode($response);
            }

            $response = (array) $response;

            if ($api_name == "sms-man") {
                if (isset($response['error_msg'])) {
                    echo '{"status":"500","message":"Error : ' . $response['error_msg'] . '"}';
                } else {
                    $response = (array) $response[$platform_data['platform_id']];
                    echo '{"status":"200","message":"' . $platform_data['platform_name'] . '(' . $data['server_name'] . ')' . ' numbers left: ' . $response['numbers'] . '."}';
                }
            }
        }
    }
}
