<?php
require_once __DIR__ . '/../../include/config.php';

$curl = curl_init();
$reference = isset($_GET['reference']) ? $_GET['reference'] : '';

if(!$reference){
  die('No reference supplied');
}

curl_setopt_array($curl, array(
  CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . $reference,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HTTPHEADER => [
    "accept: application/json",
    // "authorization: Bearer sk_live_1960ced191558c0fb0e289a98b139c23b54d4e79",
    "authorization: Bearer sk_test_8c3f52a64d5be3809d007e338cb511000afc8680",
    "cache-control: no-cache"
  ],
));


$response = curl_exec($curl);
$err = curl_error($curl);

if($err){
  // there was an error contacting the Paystack API
  die('Curl returned error: ' . $err);
}

$tranx = json_decode($response);

if(!$tranx->status){
  // there was an error from the API
  die('API returned error: ' . $tranx->message);
}

$current_time_in_ist = date('Y-m-d H:i:s');
$find_token = new radiumsahil();
$check_token = $find_token->check_token($_SESSION['token']);

// print_r($tranx->data->status);
// die();

if('success' === $tranx->data->status){
  if ($check_token === false) {
    echo '{"status":"500","message": "Token Expired Please Logout And Login Again"}';
  } else {
    $user_id = $check_token;    
    $sql5 = mysqli_query($conn,"SELECT * FROM user_wallet WHERE user_id='".$user_id."'");
    $user_data = mysqli_fetch_assoc($sql5);
    
    $amount_charged = substr($tranx->data->amount, 0, -2);

    $add_balance = $user_data['balance'] + $amount_charged;
    $add_total_rc = $user_data['total_recharge'] + $amount_charged;
    
    $sql6 = mysqli_query($conn, "UPDATE user_wallet SET balance='$add_balance', total_recharge='$add_total_rc' WHERE user_id='".$user_id."'"); 
    $sqladd2 = "UPDATE user_transaction SET amount = '$amount_charged', date = '$current_time_in_ist', status = '1' WHERE txn_id = '$reference'";
    mysqli_query($conn, $sqladd2);
    
    $formatted_amount = number_format($amount_charged,);
    $_SESSION['success_message'] = "Your wallet has been credited with ₦ $formatted_amount";
    header("Location: " . WEBSITE_URL . "/payment-success");
  }
}else{
  $amount_charged = substr($tranx->data->amount, 0, -2);
  $sqladd2 = "UPDATE user_transaction SET amount = '$amount_charged' date='$current_time_in_ist', status = '3' WHERE $txn_id = '$reference')";
  mysqli_query($conn, $sqladd2);

  $_SESSION['error_message'] = "Your payment was unsuccessful please try again.";
  header("Location: " . WEBSITE_URL . "/payment-failed");
}

?>