<?php
require_once __DIR__ . '/../../include/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputData = file_get_contents('php://input');
    $signatureHeader = $_SERVER['HTTP_PAYMENTPOINT_SIGNATURE'];
    $secretKey = '#';
    $calculatedSignature = hash_hmac('sha256', $inputData, $secretKey);

    if (!hash_equals($calculatedSignature, $signatureHeader)) {
        http_response_code(400);
        exit;
    }

    $webhookData = json_decode($inputData, true);
    if ($webhookData === null) {
        http_response_code(400);
        exit;
    }

    $transactionId = $webhookData['transaction_id'] ?? null;
    $amountPaid = $webhookData['amount_paid'] ?? null;
    $settlementAmount = $webhookData['settlement_amount'] ?? null;
    $transactionStatus = $webhookData['transaction_status'] ?? null;
    $customerEmail = $webhookData['customer']['email'] ?? null;
    // $customerPhone = $webhookData['customer']['phone'] ?? null;
    $description = $webhookData['description'] ?? null;

    if (!$transactionId || !$amountPaid || !$settlementAmount || !$transactionStatus || !$customerEmail) {
        http_response_code(400);
        exit;
    }

    $user_query = $conn->query("SELECT * FROM user_data WHERE email='" . $conn->real_escape_string($customerEmail) . "'");
    if (!$user_query || $user_query->num_rows === 0) {
        http_response_code(404);
        exit;
    }
    $user = $user_query->fetch_assoc();
    $user_id = $user['id'];

    // ✅ Step: Check if transaction already exists
    $checkTxn = $conn->query("SELECT id FROM user_transaction WHERE txn_id='" . $conn->real_escape_string($transactionId) . "' LIMIT 1");
    if ($checkTxn && $checkTxn->num_rows > 0) {
        // Transaction already processed; avoid double credit
        http_response_code(200);
        echo "Transaction already processed.";
        exit;
    }

    // Step: Insert transaction record
    $current_time_in_ist = date('Y-m-d H:i:s');
    $sqladd = "INSERT INTO user_transaction (user_id, amount, date, type, txn_id, status) 
               VALUES ('$user_id', '$settlementAmount', '$current_time_in_ist', 'Paymentpoint', '$transactionId', '1')";
    mysqli_query($conn, $sqladd);

    // Update user wallet
    $sqlwalletadd = mysqli_query($conn, "SELECT * FROM user_wallet WHERE user_id='$user_id'");
    $user_wallet_data = mysqli_fetch_assoc($sqlwalletadd);

    $amount_charged = $settlementAmount;
    $add_balance = $user_wallet_data['balance'] + $amount_charged;
    $add_total_rc = $user_wallet_data['total_recharge'] + $amount_charged;

    mysqli_query($conn, "UPDATE user_wallet SET balance='$add_balance', total_recharge='$add_total_rc' WHERE user_id='$user_id'");

    // Referral Bonus
    $refer_query = mysqli_query($conn, "SELECT * FROM refer_data WHERE user_id='$user_id'");
    $refer_data = mysqli_fetch_assoc($refer_query);

    if ($refer_data['refer_by'] != "" && $settlementAmount >= 1000) {
        $sql510 = mysqli_query($conn, "SELECT * FROM refer_data WHERE own_code='" . $refer_data['refer_by'] . "'");
        $refer_data1 = mysqli_fetch_assoc($sql510);

        $add_refer_bal = 100;
        $total_add_refer = $refer_data1['balance'] + $add_refer_bal;
        $total_earn_refer = $refer_data1['total_earn'] + $add_refer_bal;

        mysqli_query($conn, "UPDATE refer_data SET balance='$total_add_refer', total_earn='$total_earn_refer' WHERE own_code='" . $refer_data['refer_by'] . "'");

        // Credit referred user's wallet
        $refer_user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM refer_data WHERE own_code='" . $refer_data['refer_by'] . "'"));
        $user_referred = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM user_data WHERE id='" . $refer_user_data['user_id'] . "'"));

        $refer_wallet_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM user_wallet WHERE user_id='" . $user_referred['id'] . "'"));
        $add_balance = $refer_wallet_data['balance'] + $add_refer_bal;
        $add_total_rc = $refer_wallet_data['total_recharge'] + $add_refer_bal;

        mysqli_query($conn, "UPDATE user_wallet SET balance='$add_balance', total_recharge='$add_total_rc' WHERE user_id='" . $user_referred['id'] . "'");
        $referred_user_id = $refer_user_data['user_id'];

        // Add Referral History
        mysqli_query($conn, "INSERT INTO refer_history (user_id, type, date, amount, status) 
                            VALUES ('$referred_user_id', 'Referral Earning via Paymentpoint', '$current_time_in_ist', '100', '1')");
    }

    http_response_code(200);
    echo "Webhook processed successfully.";
}
?>
