<?php
require_once __DIR__ . '/../../include/config.php';

function log_message($message) {
    // You can specify a file path for custom logs
    error_log(date('[Y-m-d H:i:s] ') . $message . PHP_EOL, 3, __DIR__ . '/api_debug.log');
}

if (isset($_POST['token']) && !empty($_POST['token'])) {
    // Sanitize the inputs
    $token = mysqli_real_escape_string($conn, $_POST['token']);

    // Validate token
    $find_token = new radiumsahil();
    $check_token = $find_token->check_token($token);
    $find_token->closeConnection();

    // log_message("Token checked: " . ($check_token !== false ? "Valid (User ID: $check_token)" : "Invalid"));

    if ($check_token === false) {
        echo json_encode(['status' => '3', 'msg' => 'Token Expired Please Logout And Login Again']);
        exit();
    }

    // Check if the user has a phone number
    $user_query = $conn->query("SELECT * FROM user_data WHERE id='$check_token'");
    $user = $user_query->fetch_assoc();

    if (empty($user['phone_number'])) {
        echo json_encode(['status' => '2', 'msg' => 'Please enter a phone number in your profile to generate a bank account.']);
        exit();
    }

    // Prepare the request data for API call
    $customerEmail = $user['email'];
    $customerName = $user['name'];
    $customerPhoneNumber = $user['phone_number'];
    $bankCode = ['20946']; // Bank code
    $businessId = "#";
    
    // Set up the headers and make the API request
    $url = 'https://api.paymentpoint.co/api/v1/createVirtualAccount';
    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer #',
        'api-key: #',
    ];

    $data = [
        'email' => $customerEmail,
        'name' => $customerName,
        'phoneNumber' => $customerPhoneNumber,
        'bankCode' => $bankCode,
        'businessId' => $businessId,
    ];

    $dataString = json_encode($data);
    // log_message("Sending API request: $dataString");

    // Using cURL to send the API request
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        log_message("cURL error: $curlError");
    }

    log_message("API response: $response");

    $responseData = json_decode($response, true);

    if (
    empty($responseData['bankAccounts']) || count($responseData['errors']) > 0
    ) {
        $errorMsg = 'Unable to create your bank account.';
        if (!empty($responseData['errors'])) {
            $errorMsg .= ' ' . implode(' ', $responseData['errors']);
        }
    
        // log_message("Bank account creation failed despite success status: $errorMsg");
        echo json_encode(['status' => '2', 'msg' => $errorMsg]);
    } elseif (
        isset($responseData['status']) &&
        $responseData['status'] === "success" &&
        !empty($responseData['bankAccounts'])
    ) {
        // Extract the bank account details
        $bankAccount = $responseData['bankAccounts'][0];
        $account_data = [
            'bank_code' => $bankAccount['bankCode'],
            'account_number' => $bankAccount['accountNumber'],
            'account_name' => $bankAccount['accountName'],
            'bank_name' => $bankAccount['bankName'],
            'reserved_account_id' => $bankAccount['Reserved_Account_Id']
        ];
    
        $query = "INSERT INTO bank_accounts(user_id, bank_code, account_number, account_name, bank_name, reserved_account_id)
                  VALUES ('{$check_token}', '{$account_data['bank_code']}', '{$account_data['account_number']}', '{$account_data['account_name']}', '{$account_data['bank_name']}', '{$account_data['reserved_account_id']}')";
    
        $sql = $conn->query($query);
        // log_message("SQL Insert Query: $query");
        // log_message("SQL Insert Success: " . ($sql ? "Yes" : "No"));
    
        if ($sql) {
            echo json_encode(['status' => '1', 'msg' => 'Bank account generated successfully!', 'data' => $account_data]);
        } else {
            echo json_encode(['status' => '2', 'msg' => 'Failed to generate bank account.']);
        }
    } else {
        // log_message("Unexpected or malformed API response: " . json_encode($responseData));
        echo json_encode(['status' => '2', 'msg' => 'Unexpected response from the bank account API.']);
    }

} else {
    // log_message("Missing POST parameter: token");
    echo json_encode(['status' => '2', 'msg' => 'Missing Required Parameters']);
}