<?php
require_once __DIR__ . '/../../include/config.php';

function generateRandomString($length = 30)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $random_string = '';

    for ($i = 0; $i < $length; $i++) {
        $random_string .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $random_string;
}
function generateOTP($length = 6)
{
    $characters = '0123456789';
    $otp = '';

    for ($i = 0; $i < $length; $i++) {
        $otp .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $otp;
}
function generateUsername($name, $conn) {
    $baseUsername = strtolower(preg_replace("/[^a-zA-Z0-9]/", "", $name));
    $username = $baseUsername;
    $counter = 1;

    // Check for uniqueness
    while (true) {
        $stmt = $conn->prepare("SELECT id FROM user_data WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows == 0) {
            break; // Username is unique
        }

        $username = $baseUsername . $counter;
        $counter++;
    }

    return $username;
}
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$deviceString = "";
$current_time_in_ist = date('Y-m-d H:i:s');
if (preg_match('/iPhone|iPad|iPod/i', $user_agent)) {
    $deviceString = "Device: Apple iOS";
} elseif (preg_match('/Android/i', $user_agent)) {
    $deviceString = "Device: Android";
} elseif (preg_match('/Windows Phone/i', $user_agent)) {
    $deviceString = "Device: Windows Phone";
} elseif (preg_match('/Macintosh|Mac OS X/i', $user_agent)) {
    $deviceString = "Device: Macintosh (Mac)";
} elseif (preg_match('/Windows/i', $user_agent)) {
    $deviceString = "Device: Windows";
} elseif (preg_match('/Linux/i', $user_agent)) {
    $deviceString = "Device: Linux";
} else {
    $deviceString = "Device: Unknown";
}

$user_agent = $_SERVER['HTTP_USER_AGENT'];
$browserData = "";

// Use a regular expression to extract browser and version
if (preg_match('/(MSIE|Edge|Firefox|Chrome|Safari|Opera)[\/\s](\d+\.\d+)/i', $user_agent, $matches)) {
    $browser = $matches[1]; // Browser name
    $version = $matches[2]; // Browser version
    $browserData = "Browser: " . $browser . " " . $version;
} else {
    $browserData = "Browser information not found.";
}

function validateEmail($email) {
    // A simple regular expression to check if the email is valid
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}
function random($length = 25) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $random_string = '';

    for ($i = 0; $i < $length; $i++) {
        $random_string .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $random_string;
}
if (!isset($_POST['email']) || $_POST['email'] == "") {
    echo '{"status": "2", "msg": "Enter Email"}';
} elseif (!isset($_POST['password']) || $_POST['password'] == "") {
    echo '{"status": "2", "msg": "Enter Password"}';
} elseif (!isset($_POST['name']) || $_POST['name'] == "") {
    echo '{"status": "2", "msg": "Enter Name"}';
} elseif (!isset($_POST['phone_number']) || $_POST['phone_number'] == "") {
    echo '{"status": "2", "msg": "Enter Phone Number"}';
} elseif (strlen($_POST['password']) < 6) {
    echo '{"status": "2", "msg": "Password must be at least 6 characters long"}';
} elseif (!validateEmail($_POST['email'])) {
    echo '{"status": "2", "msg": "Enter Valid Email Address"}';
} 
// elseif (!isset($_POST['token']) || $_POST['token'] == "") {
//     echo '{"status": "2", "msg": "Enter Valid token "}';
// } 
else {
// $response = $_POST['g-recaptcha-response'];
// $secret_key = $site_data['captcha_secret_key'];
// $verifyUrl = "https://www.google.com/recaptcha/api/siteverify?secret=$secret_key&response=$response";
// $verificationResponse = file_get_contents($verifyUrl);
// $responseData = json_decode($verificationResponse);

// if ($responseData->success) {
    $date = date("Y-m-d H:i:s");
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $phone_number = mysqli_real_escape_string($conn, $_POST['phone_number']);
    $username = generateUsername($name, $conn);
    $password = md5($_POST['password']);
    // Check if email already exists
    $sql = $conn->prepare("SELECT * FROM user_data WHERE email = ?");
    $sql->bind_param("s", $email);
    $sql->execute();
    $result = $sql->get_result();

    if ($result->num_rows > 0) {
        echo '{"status": "2","msg": "Email Already Registered"}';
        exit();
    }

    // Check if phone number already exists
    $sqlPhone = $conn->prepare("SELECT * FROM user_data WHERE phone_number = ?");
    $sqlPhone->bind_param("s", $phone_number);
    $sqlPhone->execute();
    $resultPhone = $sqlPhone->get_result();

    if ($resultPhone->num_rows > 0) {
        echo '{"status": "2","msg": "Phone Number Already Registered"}';
        exit();
    }
    
    $sql2 = $conn->prepare("INSERT INTO user_data(name, username, email, phone_number, password, type, email_verified, register_date, image_url, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $type = "user";
    $img_url = "";
    $email_verified = "1";
    $status = 1; // Change this to an integer variable
    $sql2->bind_param("sssssssssi", $name, $username, $email, $phone_number, $password, $type, $email_verified, $date, $img_url, $status);
    $sql2->execute();
    $user_id = $conn->insert_id;
    $balance = 0;
    $total_recharge = 0;
    $total_otp = 0;
    $sql3 = $conn->prepare("INSERT INTO user_wallet(user_id, balance, total_recharge, total_otp) VALUES (?, ?, ?, ?)");
    $sql3->bind_param("siii", $user_id, $balance, $total_recharge, $total_otp);
    $sql3->execute();
    if(isset($_POST['refer_id']) || $_POST['refer_id'] != "") {
        $random = random();
        $sql33=$conn->query("SELECT * FROM refer_data WHERE own_code='".$_POST['refer_id']."'");
        if(mysqli_num_rows($sql33) == 1){
            mysqli_query($conn,"INSERT INTO refer_data (user_id, balance, own_code, refer_by, transfer, total_earn) VALUES ('".$user_id."', '0', '".$random."', '".$_POST['refer_id']."', '0','0')");          
        }else{
            mysqli_query($conn,"INSERT INTO refer_data (user_id, balance, own_code, refer_by, transfer, total_earn) VALUES ('".$user_id."', '0', '".$random."', '', '0','0')");          
        } 
    } 

    $token = generateRandomString();
    $user_ip = $_SERVER['REMOTE_ADDR'];
    $_SESSION['token'] = $token;
    $otp = generateOTP();

    $sql22 = mysqli_query($conn, "SELECT * FROM login_token WHERE user_id='" . $user_id . "'");
    if (mysqli_num_rows($sql22) == 0) {
        // The numbers where 3 before which probably means that the token has not been validated yet
        $sql2 = $conn->query("INSERT INTO login_token(user_id, token, create_date, device, browser, ip, otp, status) VALUES ('" . $user_id . "','" . $token . "','" . $current_time_in_ist . "','" . $deviceString . "','" . $browserData . "','" . $user_ip . "','" . $otp . "','1')");
    } else {
        $sql23 = $conn->query("UPDATE login_token SET token='" . $token . "', otp='" . $otp . "', status='1' WHERE user_id='" . $user_id . "'");
    }

    $msg = '<!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Email Verification</title>
    </head>
    <body style="font-family: Arial, sans-serif;">
    
        <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
            <div style="text-align: center;">
                <img src="https://accsmsverify.ng/img/temi_120px.jpg" alt="Company Logo" style="max-width: 100%; height: auto;"><br>
                <span color: #496fd9;>Accsmsverify</span>
            </div>
            
            <h2 style="text-align: center; color: #333;">Email Verification</h2>
            <p style="font-size: 16px; line-height: 1.6;">Thank you for registering! To complete your account setup, please use the following verification code:</p>
            
            <div style="background-color: #f7f7f7; border-radius: 5px; padding: 15px; margin-top: 20px;">
                <p style="font-size: 18px; font-weight: bold; text-align: center; margin: 0; color: #333;">Your Verification Code:</p>
                <p style="font-size: 24px; font-weight: bold; text-align: center; margin: 10px 0; color: #007bff;">' . $otp . '</p>
            </div>
    
            <p style="font-size: 16px; line-height: 1.6; margin-top: 20px;">Please enter this code on the verification page to confirm your email address. This code is valid for a limited time only.</p>
    
            <p style="font-size: 16px; line-height: 1.6;">If you did not request this verification code, please disregard this email. Your account will not be activated.</p>
    
            <p style="font-size: 16px; line-height: 1.6;">Thank you,<br>Accs
            sverify</p>
        </div>
    
    </body></html>';

    $mail = new MailSender();

    // if ($mail->sendMail($email, "Important: Verify Your Email to Access Your Account", $msg)) {
    //     $_SESSION['registered_email'] = $email;
    //     $_SESSION['generated_email_code'] = $otp;
    //     echo '{"status": "1","msg": "Register Successful"}';
    //     exit();
    // } else {
    //     echo '{"status": "2", "msg": "There was an error sending verification email code"}';
    // }
    echo '{"status": "1","msg": "Register Successful"}';
// }else{   
//   echo '{"status": "2","msg": "Captcha Expired Refresh Page"}';        
// }
}
$conn->close();
?>
