<?php
require_once __DIR__ . '/../../include/config.php';

function generateRandomToken(){

}

if (!isset($_POST['email']) || $_POST['email'] == "") {
    echo '{"status": "2","msg": "Enter Email"}';
}else{
    $email = $_POST['email'];

    // Verify that the email is registered
    $sql1 = $conn->prepare("SELECT * FROM user_data WHERE email = ?");
    $sql1->bind_param("s", $email);
    $sql1->execute();
    $result = $sql1->get_result();

    if ($result->num_rows === 0) {
        echo '{"status": "2","msg": "This email is not registered"}';
        exit();
    }

    $data = $result->fetch_assoc();

    // Generate a unique token
    $token = bin2hex(random_bytes(16));
    // Set token expiration time (1 hour from now)
    $expires_at = date("Y-m-d H:i:s", time() + 3600);

    $sql2 = $conn->prepare("INSERT INTO password_resets (email, token, expires_at) VALUES (?, ?, ?)");
    $sql2->bind_param("sss", $email, $token, $expires_at);
    
    if($sql2->execute()){

        $msg = '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Email Verification</title>
        </head>
        <body style="font-family: Arial, sans-serif;">
        
            <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
                <div style="text-align: center;">
                    <img src="https://accsmsverify.ng/img/temi.jpg" alt="Company Logo" width="100">
                </div>
                
                <h2 style="text-align: center; color: #333;">Password Reset</h2>
                <p style="font-size: 16px; line-height: 1.6;">Hello ' . $data['name'] . ',</p>

                <p style="font-size: 16px; line-height: 1.6;">You requested a password reset on your account.</p>

                <p style="font-size: 16px; line-height: 1.6;">Please click the button below to set a new password on your account</p>

                <p>
                    <a href="' . WEBSITE_URL . '/reset-password?token=' . $token . '" style="margin:0;border:0 solid #496fd9;border-radius:4px;color:#fefefe;display:inline-block;font-size:14px;font-weight:400;line-height:1.3;margin:0;padding:12px 32px 12px 32px;text-align:left;text-decoration:none;"></a>
                </p>

                <p style="font-size: 16px; line-height: 1.6;">If you did not initiate this request, please ignore this email and contact our Support Team immediately.</p>
                
                <p style="font-size: 16px; line-height: 1.6;">
                    If you’re having trouble clicking the "Forgot Password" button, copy and paste the URL below into your web browser: 
                    ' . WEBSITE_URL . '/reset-password?token=' . $token . '
                </p>

                <p style="font-size: 16px; line-height: 1.6;">Thank you,<br>Accsmsverify</p>
            </div>
        
        </body>
        </html>';

        $mail = new MailSender();

        if ($mail->sendMail($data['email'], "Forgot Password Reset", $msg)) {
            echo '{"status": "1", "msg": "success"}';
        }
    }else{
        echo '{"status": "2", "msg": "Unable to process information"}';
    }
}

$conn->close();